from django.db import migrations, models
import django.contrib.postgres.fields.jsonb


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0121_oebs_data'),
    ]

    operations = [
        migrations.AddField(
            model_name='service',
            name='functions',
            field=django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=list, verbose_name='Service functions')
        ),
        migrations.CreateModel(
            name='ServiceTypeFunction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(db_index=True, max_length=64, unique=True)),
                ('name', models.CharField(max_length=64)),
                ('name_en', models.CharField(max_length=64)),
                ('active', models.BooleanField(default=True)),
                ('description_en', models.TextField(
                    blank=True, default='',
                    verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (en)')
                 ),
                ('description', models.TextField(
                    blank=True, default='',
                    verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435')
                 ),
            ],
        ),
        migrations.AddField(
            model_name='servicetype',
            name='functions',
            field=models.ManyToManyField(
                related_name='used_in_types', to='services.ServiceTypeFunction',
                default=None, blank=True, null=True,
                verbose_name='Functions'
            ),
        ),
    ]
