from plan.common.utils import wrap
from plan.common.utils.collection.mapping import DotAccessedDict
from plan.roles.models import Role
from plan.services.models import ServiceMember


def prepare_new_members(data, prepared):
    result = []
    for member in data.new_members_data:
        result.append(DotAccessedDict(member))
    return result


def prepare_present_members(data, prepared):
    return data.service.members.team()


def prepare_from_department(data, prepared):
    for member_data in data.new_members_data:
        if 'from_department' not in member_data:
            member_data['from_department'] = None


def prepare_exclusive_owner(data, prepared):
    try:
        return data.service.members.get(
            role__code=Role.EXCLUSIVE_OWNER,
        )
    except ServiceMember.DoesNotExist:
        pass


@wrap.wrap_in_dict
def prepare_new_departments(data, prepared):
    for member_data in data.new_members_data:
        department = member_data.get('from_department')
        if department:
            # тут будут повторы, но они все кладутся по id в dict,
            # так что это норм
            yield (
                (department.id, member_data['role'].id),
                (
                    department,
                    member_data['role'],
                    member_data.get('deprive_after'),
                    member_data.get('deprive_at'),
                ),
            )


@wrap.wrap_in_dict
def prepare_present_departments(data, prepared):
    departments_memberships = data.service.department_memberships.all()
    present_departments = [(dm.department, dm.role) for dm in departments_memberships]
    for department, role in present_departments:
        yield (department.id, role and role.id), (department, role)


def prepare_present_responsible(data, prepared):
    return [r.staff for r in data.service.members.non_head_responsibles()]


def prepare_heads(data, prepared):
    return [m.staff for m in data.service.members.heads()]
