def fetch_natural_id(member):
    if hasattr(member, 'person_id'):
        return member.person_id, member.role_id
    elif hasattr(member, 'staff_id'):
        return member.staff_id, member.role_id
    else:
        return member.person.id, member.role.id


def merge_duplicate_memberships(data):
    """
    Добавляем в data result с ключами create/update для создания и
    редактирования существующих мемберов на основе добавляемых.
    """
    new, present = data.new_members, data.present_members

    data.result = {
        'members': {
            'to_create': [],
            'to_update': [],
        }
    }
    members_cmd = data.result.members

    present_memberships = {fetch_natural_id(m): m for m in present}

    for new_member in new:
        natural_id = fetch_natural_id(new_member)

        # если такого не было еще, конечно создаем
        if natural_id not in present_memberships:
            members_cmd.to_create.append(new_member)
            continue

        # а если уже был, то, возможно, нужно будет его обновить
        if new_member.from_department is None:
            # если он обычный, то тут нечего обновлять
            continue

    return data


def merge_departments(data):
    """
    Нужно привязать только новые подразделения
    """
    new, present = data.new_departments, data.present_departments
    data.result.departments = {'to_create': []}

    for key, values in new.items():
        if key not in present:
            data.result.departments.to_create.append(values)

    return data


def separate_responsible(data):
    """
    Разбиваем данные на тех, кому надо выдать роль и у кого отозвать
    """
    asked = set(person['person'] for person in data.new_responsible_data)
    present = set(data.present_responsible)
    heads = set(data.heads)

    data.result = {
        'responsible': {
            'to_create': asked - present - heads,
            'to_remove': present - asked - heads,
        }
    }

    return data
