from django.conf import settings
from rest_framework import routers

from plan.assessors.api.views import PermissiveDepartmentsView, PermissiveMembersView
from plan.services.api.contacts import ContactsView
from plan.services.api.departments import DepartmentsView
from plan.services.api.members import MembersView
from plan.services.api.moves import MovesView
from plan.services.api.responsibles import ResponsiblesView
from plan.services.api.services import ServicesView
from plan.services.api.tags import ServiceTagsView

router = routers.DefaultRouter()
router.register(r'contacts', ContactsView, basename='contact')
router.register(r'moves', MovesView, basename='moves')
router.register(r'responsibles', ResponsiblesView, basename='responsible')
router.register(r'services', ServicesView, basename='service')
router.register(r'tags', ServiceTagsView, basename='tags')

if settings.CROWDTEST:
    router.register(r'departments', PermissiveDepartmentsView, basename='department')
    router.register(r'members', PermissiveMembersView, basename='member')
else:
    router.register(r'departments', DepartmentsView, basename='department')
    router.register(r'members', MembersView, basename='member')
