from django.contrib.auth.models import ContentType, Permission
from django.db.models.signals import post_save, pre_delete
from django.dispatch import receiver

from plan.idm import nodes
from plan.services import models
from plan.services.constants.permissions import (
    SERVICE_TAG_APP,
    SERVICE_TAG_MODEL,
    CHANGE_SERVICE_TAG_CODENAME,
)
from plan.services.tasks import purge_service_tag_permission


@receiver(post_save, sender=models.ServiceTag)
def create_service_tag_permission(sender, instance, created=False, **kwargs):
    if created:
        Permission.objects.create(
            codename=CHANGE_SERVICE_TAG_CODENAME % instance.slug,
            content_type=ContentType.objects.get(app_label=SERVICE_TAG_APP, model=SERVICE_TAG_MODEL))


@receiver(pre_delete, sender=models.ServiceTag)
def remove_tag_roles(sender, instance, **kwargs):
    nodes.remove_service_tag_node(instance)
    purge_service_tag_permission.apply_async(args=[instance.slug], countdown=60)
