from django.utils.translation import ugettext_lazy as _

from plan.common.utils.enum import EnumMeta, EnumChoice


class SERVICEMEMBER_STATE(metaclass=EnumMeta):
    REQUESTED = EnumChoice('requested', name=_('Запрошен'))
    ACTIVE = EnumChoice('active', name=_('Выдан'))
    DEPRIVING = EnumChoice('depriving', name=_('Отзывается'))
    DEPRIVED = EnumChoice('deprived', name=_('Отозван'))


class SERVICE_STATE(metaclass=EnumMeta):
    IN_DEVELOP = EnumChoice('develop', name=_('Развивается'))
    SUPPORTED = EnumChoice('supported', name=_('Поддерживается'))
    NEEDINFO = EnumChoice('needinfo', name=_('Требуется информация'))
    CLOSED = EnumChoice('closed', name=_('Закрыт'))
    DELETED = EnumChoice('deleted', name=_('Удалён'))

    ALL_STATES = {
        IN_DEVELOP,
        SUPPORTED,
        NEEDINFO,
        CLOSED,
        DELETED,
    }

    ALIVE_STATES = ALL_STATES - {DELETED}
    ACTIVE_STATES = ALIVE_STATES - {CLOSED}
    NORMAL_STATES = ACTIVE_STATES - {NEEDINFO}


SERVICE_STATE_GROUPS = (
    ('all', {
        'name': _('Все'),
        'states': SERVICE_STATE.ALL_STATES,
    }),
    ('active', {
        'name': _('Активные'),
        'states': SERVICE_STATE.ACTIVE_STATES,
    }),
)
