from django.conf.urls import url

from plan.services.views import create, detail
from plan.services.views.catalog.views import ServiceCatalogView
from plan.services.api.contacts import ContactsReplaceView
from plan.services.api.slug import MakeSlugFrontendApiView

urlpatterns = [
    url(
        r'^services/$',
        ServiceCatalogView.as_view(),
        name='service_list'
    ),
    url(
        r'^service-actions/create/$',
        create.create_view,
        name='service_create'
    ),
    url(
        r'^service-actions/make_slug/$',
        MakeSlugFrontendApiView.as_view({'get': 'list'}),
        name='service_make_slug'
    ),
    url(
        r'^services/(?P<pk_or_slug>[-a-zA-Z0-9_]+)/$',
        detail.ServiceDetailView.as_view(),
        name='service'
    ),
    url(
        r'^services/(?P<pk_or_slug>[-a-zA-Z0-9_]+)/actions/contacts_replace/$',
        ContactsReplaceView.as_view({'post': 'post'}),
        name='service_action_contacts_replace'
    ),
]
