from django.conf import settings


class OrderedChoices(object):
    def __init__(self, *choices):
        self._choices = ((db_value, text_value) for attr, db_value, text_value in choices)
        self.match = {attr: db_value for attr, db_value, text_value in choices}

    def __getattr__(self, item):
        if item in self.match:
            return self.match[item]
        else:
            raise AttributeError(item)

    def choices(self):
        return self._choices


AFFILIATION = OrderedChoices(
    (
        'YANDEX', 'yandex',
        {
            'en': 'Yandex',
            'ru': 'Яндекс',
        },
    ),
    (
        'YAMONEY', 'yamoney',
        {
            'en': 'Yandex.Money',
            'ru': 'Яндекс.Деньги',
        },
    ),
    (
        'EXTERNAL', 'external',
        {
            'en': 'External',
            'ru': 'Внешний',
        },
    )
)

GENDER = OrderedChoices(
    (
        'MALE', 'M',
        {
            'en': 'male',
            'ru': 'мужской'
        }
    ),
    (
        'FEMALE', 'F',
        {
            'en': 'female',
            'ru': 'женский'
        }
    ),
)

LANG = OrderedChoices(
    (
        'EN', 'en',
        {
            'en': 'English',
            'ru': 'Английский',
        }
    ),
    (
        'RU', 'ru',
        {
            'en': 'Russian',
            'ru': 'Русский'
        }
    ),
    (
        'TR', 'tr',
        {
            'en': 'Turkish',
            'ru': 'Турецкий'
        }
    ),
)

USER_MODEL = settings.AUTH_USER_MODEL

DEPARTMENT_ROLES = OrderedChoices(
    (
        'CHIEF', 'C',
        {
            'en': 'chief',
            'ru': 'Руководитель'
        }
    ),
    (
        'DEPUTY', 'D',
        {
            'en': 'deputy',
            'ru': 'Заместитель руководителя'
        }
    ),
)
