# flake8: noqa
# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2020-03-02 19:10
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('native_lang', models.CharField(blank=True, default='', max_length=2)),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('staff_id', models.PositiveIntegerField(db_index=True)),
                ('name', models.CharField(max_length=255)),
                ('name_en', models.CharField(default='', max_length=255)),
                ('short_name', models.CharField(default='', max_length=255)),
                ('short_name_en', models.CharField(default='', max_length=255)),
                ('url', models.CharField(default='', max_length=255, unique=True)),
            ],
            options={
                'db_table': 'intranet_department',
            },
        ),
        migrations.CreateModel(
            name='DepartmentStaff',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.TextField(choices=[('C', 'intranet_stuff.Department_chief'), ('D', 'intranet_stuff.Department_deputy')])),
                ('department', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='staff.Department')),
            ],
            options={
                'db_table': 'intranet_departmentstaff',
            },
        ),
        migrations.CreateModel(
            name='Staff',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('native_lang', models.CharField(blank=True, default='', max_length=2)),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('login', models.CharField(db_index=True, default='', max_length=50)),
                ('uid', models.CharField(db_index=True, max_length=16, null=True, unique=True)),
                ('first_name', models.CharField(db_index=True, default='', max_length=50)),
                ('first_name_en', models.CharField(db_index=True, default='', max_length=50)),
                ('last_name', models.CharField(db_index=True, default='', max_length=100)),
                ('last_name_en', models.CharField(db_index=True, default='', max_length=100)),
                ('is_robot', models.BooleanField(default=False)),
                ('affiliation', models.CharField(choices=[('yandex', 'intranet_stuff.Staff_AffiliationYandex'), ('yamoney', 'intranet_stuff.Staff_AffiliationYamoney'), ('external', 'intranet_stuff.Staff_AffiliationExternal')], db_index=True, max_length=32)),
                ('gender', models.CharField(choices=[('M', 'intranet_stuff.Staff_Male'), ('F', 'intranet_stuff.Staff_Female')], default='', max_length=1)),
                ('is_dismissed', models.BooleanField(default=False)),
                ('join_at', models.DateField(null=True)),
                ('quit_at', models.DateField(null=True)),
                ('lang_ui', models.CharField(choices=[('en', 'English'), ('ru', 'Russian'), ('tr', 'Turkish')], default='', max_length=2)),
                ('work_email', models.CharField(db_index=True, default='', max_length=100)),
                ('department', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='staff.Department')),
                ('user', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'intranet_staff',
            },
        ),
        migrations.AddField(
            model_name='departmentstaff',
            name='staff',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='staff.Staff'),
        ),
    ]
