from django.contrib import admin

from plan.common.base_admin import ViewModelAdmin
from plan.suspicion import models


@admin.register(models.Issue)
class IssueAdmin(ViewModelAdmin):
    list_display = ('code', 'name', 'name_en', 'is_active', 'weight',)
    list_filter = ('is_active',)


@admin.register(models.IssueGroup)
class IssueGroupAdmin(ViewModelAdmin):
    list_display = ('code', 'name', 'name_en',)


@admin.register(models.IssueGroupThreshold)
class IssueGroupThresholdAdmin(ViewModelAdmin):
    list_display = ('issue_group', 'level', 'threshold',)
    list_filter = ('issue_group', 'level',)


@admin.register(models.Execution)
class ExecutionAdmin(ViewModelAdmin):
    list_display = ('code', 'name', 'name_en', 'is_active', 'is_critical')
    list_filter = ('is_active', 'is_critical',)


@admin.register(models.ExecutionStep)
class ExecutionStepAdmin(ViewModelAdmin):
    list_display = ('execution', 'apply_after', 'is_active',)
    list_filter = ('is_active', 'execution_chain')


@admin.register(models.ExecutionChain)
class ExecutionChainAdmin(ViewModelAdmin):
    list_display = ('code',)


@admin.register(models.ServiceIssue)
class ServiceIssueAdmin(ViewModelAdmin):
    list_display = ('state', 'service', 'issue', 'issue_group')
    list_filter = ('state', 'issue', 'issue_group')
    search_fields = ('service__name', 'service__slug')


@admin.register(models.ServiceExecutionAction)
class ServiceExecutionActionAdmin(ViewModelAdmin):
    list_display = ('service_issue', 'execution', 'should_be_applied_at', 'applied_at')
    list_filter = ('service_issue__issue', 'execution')
    search_fields = ('service_issue__service__name', 'service_issue__service__slug',)


@admin.register(models.ServiceTrafficStatus)
class ServiceTrafficStatusAdmin(ViewModelAdmin):
    list_display = ('service', 'issue_group', 'issue_count', 'level')


@admin.register(models.Complaint)
class ComplaintAdmin(ViewModelAdmin):
    list_display = ('service', 'created_at', 'author', 'message')
    search_fields = (
        'service__name',
        'service__slug',
        'author__login',
    )
