from django.utils.translation import ugettext as _


ISSUE_GROUP_SERIALIZER_META_FIELDS = ('id', 'code', 'name')
SERVICE_TRAFFIC_STATUS_SERIALIZER_META_FIELDS = ('id', 'group', 'issue_count', 'level')

SUSPICION_DIGEST_MAIL_TEMPLATES = 'notifications.services.suspicious.suspicion_digest'


class LEVELS(object):
    OK = 'ok'
    WARN = 'warning'
    CRIT = 'critical'

    CHOICES = (
        (OK, _('Ок')),
        (WARN, _('Предупреждение')),
        (CRIT, _('Все плохо')),
    )

    NOT_OK = {WARN, CRIT}

    THRESHOLD_CHOICES = (
        (WARN, _('Предупреждение')),
        (CRIT, _('Все плохо')),
    )


class ServiceIssueStates(object):
    ACTIVE = 'active'
    REVIEW = 'review'
    APPEALED = 'appealed'
    FIXED = 'fixed'

    CHOICES = (
        (ACTIVE, _('Активна')),
        (REVIEW, _('На рассмотрении')),
        (APPEALED, _('Оспорена')),
        (FIXED, _('Исправлена')),
    )

    ALL_STATUSES = {ACTIVE, REVIEW, APPEALED, FIXED}
    ALIVE_STATUSES = ALL_STATUSES - {FIXED}
    PROBLEM_STATUSES = ALIVE_STATUSES - {APPEALED}


class ServiceAppealIssueStates(object):
    REQUESTED = 'requested'
    APPROVED = 'approved'
    REJECTED = 'rejected'

    ACTIVE_STATES = {REQUESTED, APPROVED}

    CHOICES = (
        (REQUESTED, 'Запрошена'),
        (APPROVED, 'Одобрена'),
        (REJECTED, 'Отклонена'),
    )


class FrontendTrafficSerializerFields(object):

    _INCLUDE = {'id', 'service_id'}
    _EXCLUDE = {'group'}

    GROUP_FIELDS = {
        field: 'issue_group__' + field
        for field in ISSUE_GROUP_SERIALIZER_META_FIELDS + ('name_en',)
    }

    FIELD_LIST_TO_SELECT = (
        set(SERVICE_TRAFFIC_STATUS_SERIALIZER_META_FIELDS) |
        set(GROUP_FIELDS.values()) |
        _INCLUDE
    ) - _EXCLUDE
