# encoding: utf-8

from plan.common.utils.oauth import get_abc_zombik
from plan.common.person import Person
from plan.services.models import Service, ServiceCloseRequest
from plan.services import tasks


class StateChangingExecution(object):
    state = None

    def change_state(self, service):
        person = Person(get_abc_zombik())

        if self.state == Service.states.CLOSED:
            ServiceCloseRequest.request(service=service, requester=person)

        service.state = self.state
        service.save(update_fields=['state'])
        tasks.notify_staff.delay(service.pk)

        if self.state not in Service.states.ACTIVE_STATES:
            tasks.drop_requests.delay(service.pk)
