# encoding: utf-8


import logging

from plan.services.models import Service
from plan.suspicion.execution_tasks.change_state import StateChangingExecution
from plan.services.exceptions import CannotCloseOrDeleteBaseService

log = logging.getLogger(__name__)


class Execution(StateChangingExecution):
    state = Service.states.CLOSED

    def __call__(self, service):
        try:
            self.change_state(service)
        except CannotCloseOrDeleteBaseService:
            log.exception('Execution (closing) can not be applied to base service with id %d', service.id)
