import waffle
from django.conf import settings

from plan.services.models import ServiceType, ServiceTypeFunction
from plan.suspicion.issue_finders.base import BaseIssueFinder


class IssueFinder(BaseIssueFinder):
    def __call__(self, *args, **kwargs):
        if not waffle.switch_is_active(settings.SWITCH_CHECK_FUNCTIONALITY):
            return

        allowed_functions_by_type = {
            service_type.id: set(service_type.functions.filter(active=True).values_list('code', flat=True))
            for service_type in ServiceType.objects.all()
        }
        functions_names = {
            function.code: {'en': function.name_en, 'ru': function.name}
            for function in ServiceTypeFunction.objects.all()
        }
        for service in self.qs:
            current = set(service.functions)
            allowed = allowed_functions_by_type[service.service_type_id]
            if not current.issubset(allowed):
                context = {
                    'extra': [
                        functions_names[function_id] for function_id
                        in current.difference(allowed)],
                    'allowed': [
                        functions_names[function_id] for function_id
                        in allowed_functions_by_type[service.service_type_id]
                    ],
                }
                yield service.id, context, 'extra_functionality', 1
