from django.conf import settings
from django.db.models import F, Q, Subquery

from plan.services.models import Service
from plan.suspicion.issue_finders.base import BaseIssueFinder


class IssueFinder(BaseIssueFinder):
    def __call__(self, qs=None, *args, **kwargs):

        umbrellas_without_vs_lookup = Q(tags__slug=settings.GRADIENT_UMB) & ~Q(valuestream=F('parent'))

        vs_without_search_lookup = Q(tags__slug=settings.GRADIENT_VS) & ~Q(parent__slug=settings.ABC_SEARCH_PORTAL_SLUG)

        contour_without_umbrella_lookup = Q(tags__slug=settings.GRADIENT_CONTOUR, umbrella__isnull=True)

        contours_with_contour_ancestor_lookup = Q(
            id__in=Subquery(
                Service._closure_model.objects.filter(
                    depth__gt=0,
                    parent__tags__slug=settings.GRADIENT_CONTOUR,
                    child__tags__slug=settings.GRADIENT_CONTOUR
                ).values_list('child_id', flat=True)
            )
        )

        issued_services_ids = (
            Service.objects
            .get(slug=settings.ABC_SEARCH_PORTAL_SLUG)
            .get_descendants(include_self=False).filter(
                umbrellas_without_vs_lookup |
                vs_without_search_lookup |
                contour_without_umbrella_lookup |
                contours_with_contour_ancestor_lookup
            )
            .distinct()
            .values_list('id', flat=True)
        )

        for service_id in issued_services_ids:
            yield service_id, {}, 'gradient_structure', 1
