from plan import settings
from plan.services.models import Service
from plan.suspicion.issue_finders.base import BaseIssueFinder


class IssueFinder(BaseIssueFinder):
    def __call__(self, qs=None, *args, **kwargs):
        issue_services_ids = (
            Service.objects.get(slug=settings.ABC_SEARCH_PORTAL_SLUG)
            .get_descendants(include_self=False)
            .filter(valuestream__isnull=True)
            .values_list('id', flat=True)
        )

        for service_id in issue_services_ids:
            yield service_id, {}, 'gradient_vs', 1
