from django.db.models import Count

from plan.roles.models import Role
from plan.services.models import Service
from plan.suspicion.issue_finders.base import ResourceIssueFinder


class IssueFinder(ResourceIssueFinder):
    issue_key = 'hardware_managers'
    resource_category = 'hardware'

    def get_services_with_resource_managers(self):
        resource_management_roles_pks = Role.objects.get_resource_management_roles_pks('hardware')
        return set(
            Service.objects
            # ToDO: добавить фильтр по is_active после https://st.yandex-team.ru/ABC-7426
            .filter(members__role_id__in=resource_management_roles_pks)
            .values('id')
            .annotate(count=Count('members__role__code', distinct=True))
            .filter(count=len(resource_management_roles_pks))
            .values_list('id', flat=True)
        )
