from .base import BaseIssueFinder


class IssueFinder(BaseIssueFinder):
    def __call__(self, *args, **kwargs):
        for service_id, robot_login in self.qs.filter(owner__is_robot=True).values_list('pk', 'owner__login'):
            yield service_id, {'owner': robot_login}, 'owner_is_robot', 1
