from django.conf import settings
from django.db.models import OuterRef, Exists

from plan.resources.models import ServiceResource, ResourceType
from plan.services.models import Service, ServiceMember
from plan.suspicion.issue_finders.base import ResourceIssueFinder


class IssueFinder(ResourceIssueFinder):
    issue_key = 'robot_managers'
    resource_category = 'robot'

    def get_services_with_resource_managers(self):
        resource_management_members = ServiceMember.objects.filter(
            role__scope__slug=settings.ABC_ROBOTS_MANAGEMENT_SCOPE,
            service=OuterRef('pk')
        )

        services = (
            Service.objects
            .alive()
            .annotate(have_robot_management_role=Exists(resource_management_members))
        )

        return set(services.filter(have_robot_management_role=True).values_list('id', flat=True))

    def get_services_with_resources(self):
        resource_type = ResourceType.objects.get(code=settings.ROBOT_RESOURCE_TYPE_CODE)

        return set(
            ServiceResource.objects
            .filter(state__in=ServiceResource.ALIVE_STATES, type=resource_type)
            .values_list('service_id', flat=True)
        )
