import waffle
from django.conf import settings

from plan.services.models import ServiceType
from plan.suspicion.issue_finders.base import BaseIssueFinder


class IssueFinder(BaseIssueFinder):
    def __call__(self, *args, **kwargs):
        if not waffle.switch_is_active(settings.SWITCH_CHECK_ALLOWED_PARENT_TYPE):
            return

        allowed_types_map = {}
        types_names = {}
        for service_type in ServiceType.objects.all():
            allowed_types_map[service_type.id] = set(service_type.available_parents.values_list('id', flat=True))
            types_names[service_type.id] = {'ru': service_type.name, 'en': service_type.name_en}

        for service in self.qs.select_related('parent'):
            if service.parent_id and service.parent.service_type_id not in allowed_types_map[service.service_type_id]:
                context = {
                    'current': types_names[service.parent.service_type_id],
                    'allowed': [
                        types_names[service_type_id] for service_type_id
                        in allowed_types_map[service.service_type_id]
                    ]
                }
                yield service.id, context, 'wrong_parent_type', 1
