from django.utils import timezone

from django.db.models import Manager
from plan.suspicion.querysets import ServiceExecutionActionQuerySet


class ServiceExecutionActionManager(Manager.from_queryset(ServiceExecutionActionQuerySet)):

    def create_from_service_issue_and_chain(self, service_issue, execution_chain):
        execution_steps = execution_chain.steps.filter(is_active=True).select_related('execution')
        now = timezone.now()
        actions_to_create = []
        for step in execution_steps:
            action = self.model(
                service_issue=service_issue,
                execution_chain=execution_chain,
                execution=step.execution,
                should_be_applied_at=now + step.apply_after,
                issue_action_key=service_issue.get_issue_action_key(),
            )
            actions_to_create.append(action)
        self.bulk_create(actions_to_create)


class ServiceTrafficStatusManager(Manager):

    def of_services_ids(self, ids):
        return self.filter(service_id__in=ids)
