# flake8: noqa
from django.db import migrations, models

from plan.suspicion.models import ServiceAppealIssue
from collections import defaultdict


states = '(%s)' % ','.join("'%s'" % state for state in ServiceAppealIssue.STATES.ACTIVE_STATES)


def resolve_duplicates(apps, schema):
    ServiceAppeal = apps.get_model('suspicion', 'ServiceAppealIssue')
    active_appeals = ServiceAppeal.objects.filter(state__in=ServiceAppealIssue.STATES.ACTIVE_STATES).values_list(
        'service_issue',
        'requester',
        'state',
        'id',
    )
    appeals_grouped_by_issue = defaultdict(lambda: defaultdict(lambda: defaultdict(list)))

    for appeal in active_appeals:
        appeals_grouped_by_issue[appeal[0]][appeal[1]][appeal[2]].append(appeal[3])

    ids_for_delete = []

    for service_issue, requesters in appeals_grouped_by_issue.items():
        for requester in requesters:
            approved = appeals_grouped_by_issue[service_issue][requester][ServiceAppealIssue.STATES.APPROVED]
            requested = appeals_grouped_by_issue[service_issue][requester][ServiceAppealIssue.STATES.REQUESTED]

            if len(approved) > 0:
                ids_for_delete.extend(requested)
                ids_for_delete.extend(approved[:-1])
            else:
                ids_for_delete.extend(requested[:-1])

    ServiceAppeal.objects.filter(id__in=ids_for_delete).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('suspicion', '0024_auto_20191115_1657'),
    ]

    operations = [
        migrations.RunPython(code=resolve_duplicates, reverse_code=lambda *args: None),
        migrations.RunSQL('''
            CREATE UNIQUE INDEX suspicion_serviceappealissue_service_issue_requester
            ON suspicion_serviceappealissue (service_issue_id, requester_id)
            WHERE state IN %s
        ''' % states, reverse_sql='''
            DROP INDEX IF EXISTS suspicion_serviceappealissue_service_issue_requester
        ''')
    ]
