## Аутентификация
**Основной метод аутентификации:** [TVM](https://wiki.yandex-team.ru/passport/tvm2), во все наши ручки можно приходить с ``Service+User Ticket``
(кроме особых случаев их можно найти ниже)

Для того, чтобы вас пускало в апи по TVM - необходимо запросить права на ваши tvm приложения:
    - для прода [тут](https://nda.ya.ru/t/c4pe8ONw4KXkL8)
    - для тестинга [тут](https://nda.ya.ru/t/XCeJP-zy4KXkdB)

**tvm_id наших приложений**:
    - прод: ``2012190``
    - тест: ``2012192``

Сейчас c [Service Ticket](https://wiki.yandex-team.ru/passport/tvm2/stbrief/) без [User Ticket](https://wiki.yandex-team.ru/passport/tvm2/user-ticket/)
можно ходить в [следующие ручки с методом GET](https://wiki.yandex-team.ru/intranet/abc/docs/api/#authentication)

* Так же в особых случаях вам может быть разрешено приходить в апи с ``Service Ticket`` + ``UID`` пользователя
в заголовке ``X-UID`` - для согласования такого разрешения опишите свой кейс на tools@

* Аутентификация по куке ``Session_id``: применяется, чтобы сходить в ручки из браузера и в особых ручках,
помеченных [cookie]

* Deprecated способ аутентификации: по OAuth токену в заголовке ``Authorization: OAuth <token>``.
    - Если вы хотите использовать наше OAuth-приложение:
    [получение токена с нужным набором скоупов](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=23db397a10ae4fbcb1a7ab5896dc00f6);
    - Если вы хотите завести собственное OAuth-приложение (рекомендованный способ):
Документация про получение OAuth токена: https://wiki.yandex-team.ru/intranet/dev/oauth/
В списке скоупов при получении токена сервис называется ABC. Нужно заказать скоуп use:abc


## Ограничение выборки данных
Набор полей, которые будут возвращены, регулируется параметром ``fields``. Пожалуйста, всегда используйте параметр ``fields``
в вашем продакшен-коде.
В API v4 мы всегда ожидаем этот параметр, если он не передан, то возвращается минимальный набор данных.


## Паджинация: постраничная и курсорная
API v3 и v4 – близнецы-братья и отличаются только паджинацией и тем, что в v4 необходимо передавать параметр ``fields``.

В API v4 используется курсорная паджинация: она не возвращает точного количества объектов и числа страниц.
Зато выборка каждой страницы работает быстро. Фактически, запрос за следующей страницей означает
"дай мне записи, подходящие под фильтры, числом X, id которых больше id последнего объекта на предыдущей странице".

В API v3 реализована постраничная паджинация. Можно передать параметр page и получить список сущностей на странице
номер ``n``. Запросы к API ABC транслируются в SQL запросы, и запросы с page превращаются в крайне неэффективные
при большом ``n`` запросы вида ``LIMIT X OFFSET Y``. Чтобы выполнить такой запрос, нужно вычитать все предыдущие страницы,
поэтому в любой БД они небыстры. Поэтому мы рекомендуем использовать API v4.

Для перехода по страницам в API v4 используется ключ ``"next"`` на верхнем уровне JSON-ответа.

## Общие параметры
* ``page_size`` – число записей на странице. Максимум – ``1000``.
* ``page`` – номер страницы. Первая страница имеет индекс ``1``.
Пожалуйста, не используйте этот параметр и постраничную паджинацию.
Используйте эффективную курсорную паджинацию.
* ``fields`` - список полей, которые надо вернуть в ответе, через запятую.
Пожалуйста, используйте этот параметр для сокращения объёма выборок и передаваемых данных
