# flake8: noqa
from django.db import migrations, models


def fill_last_success_end(apps, schema_editor):
    TaskMetric = apps.get_model('unistat', 'TaskMetric')
    TaskMetric.objects.update(last_success_end=models.F('last_success_date'))


class Migration(migrations.Migration):

    dependencies = [
        ('unistat', '0004_taskmetric_add_fields'),
    ]

    operations = [
        migrations.RunPython(fill_last_success_end),
    ]
