import six
from django.contrib.postgres.fields import JSONField
from django.db import models

from plan.common.models import TimestampedModel


@six.python_2_unicode_compatible
class MetricsRecord(TimestampedModel):
    metrics = JSONField(default=dict)

    def __str__(self):
        return 'Last updated: {:%Y-%m-%d %H:%M}'.format(self.updated_at)


class TaskMetric(models.Model):
    task_name = models.TextField()
    last_success_start = models.DateTimeField(null=True, blank=True)
    last_success_end = models.DateTimeField(null=True, blank=True)
    send_to_unistat = models.BooleanField()
    use_for_monitoring = models.BooleanField(default=True, blank=True)
