from rest_framework.response import Response
from rest_framework.views import APIView

from plan.unistat.models import MetricsRecord
from plan.unistat import tasks


class UnistatView(APIView):
    log_context = False
    authentication_classes = []
    permission_classes = []

    def get(self, request, *args, **kwargs):

        try:
            record = MetricsRecord.objects.get()
            if record.metrics:
                metrics = record.metrics
            else:
                metrics = tasks.calculate_unistat_metrics()
                tasks.populate_unistat_metrics.delay()

        except MetricsRecord.DoesNotExist:
            metrics = tasks.calculate_unistat_metrics()
            tasks.populate_unistat_metrics.delay()

        return Response(
            [['abc_{}_max'.format(key), value] for key, value in metrics.items()],
            content_type='application/json; charset=utf-8'
        )
