from django.conf.urls import url, include
from django.contrib import admin

from plan.api import urls as common_urls
from plan.api.router import router as v3_router, v4_router, frontend_router
from plan.cabinet import urls as cabinet_urls
from plan.common import views
from plan.common.utils import readonly
from plan.idm_ext import urls as idm_ext_urls
from plan.monitorings import urls as monitorings_urls
from plan.ping.views import PingView
from plan.resources.router import router as resources_router
from plan.roles.router import router as roles_router
from plan.services.router import router as services_router
from plan.swagger import schema_view
from plan.unistat.views import UnistatView


handler404 = views.handler404

urlpatterns = [
    url(r'^', include('plan.services.urls', namespace='services')),
    url(r'^_readonly/$', readonly.ReadonlyView.as_view(), name='readonly'),
    url(r'^admin/', include(admin.site.urls)),

    url(r'^api/v3/', include(v3_router.urls, namespace='api-v3')),
    url(r'^api/v3/common/', include(common_urls.urlpatterns, namespace='api-v3-common')),

    url(r'^api/v4/', include(v4_router.urls, namespace='api-v4')),
    url(r'^api/v4/common/', include(common_urls.urlpatterns, namespace='api-v4-common')),

    url(r'^api/frontend/', include(frontend_router.urls, namespace='api-frontend')),
    url(r'^api/frontend/common/', include(common_urls.urlpatterns, namespace='api-frontend-common')),

    url(r'^api/cabinet/', include(cabinet_urls, namespace='cabinet-api')),
    url(r'^api/idm/', include('django_idm_api.urls', namespace='idm-api')),
    url(r'^api/idm-ext/', include(idm_ext_urls, namespace='idm-ext-api')),
    url(r'^api/roles/', include(roles_router.urls, namespace='roles-api')),
    url(r'^api/services/', include(services_router.urls, namespace='services-api')),
    url(r'^api/resources/', include(resources_router.urls, namespace='resources-api')),

    url(r'^common/', include('plan.common.urls', namespace='common')),
    url(r'^contacts/', include('plan.contacts.urls', namespace='contacts')),
    url(r'^departments/', include('plan.departments.urls', namespace='departments')),
    url(r'^hr/', include('plan.hr.urls', namespace='hr')),
    url(r'^monitorings/', include(monitorings_urls, namespace='monitorings')),
    url(r'^multic/', include('plan.multic.urls', namespace='multic')),
    url(r'^ping/?$', PingView.as_view(), name='ping'),
    url(r'^roles/', include('plan.roles.urls', namespace='roles')),
    url(r'^unistat/', UnistatView.as_view(), name='unistat'),

    url(r'^api/swagger(?P<format>\.json|\.yaml)$', schema_view.without_ui(cache_timeout=0), name='schema-json'),
    url(r'^api/swagger/$', schema_view.with_ui('swagger', cache_timeout=0), name='schema-swagger-ui'),
    url(r'^api/redoc/$', schema_view.with_ui('redoc', cache_timeout=0), name='schema-redoc'),
]
