PY3_LIBRARY(plan)

OWNER(g:tools-abc)

ENV(DJANGO_SETTINGS_MODULE=plan.settings)

PEERDIR(
    contrib/python/django/django-1.11
    contrib/python/requests
    contrib/python/uwsgi
    contrib/python/more-itertools
    contrib/python/psycopg2
    contrib/python/python-memcached
    contrib/python/djangorestframework
    contrib/python/django-extensions/py2
    contrib/python/drf-ujson
    contrib/python/drf-yasg
    contrib/python/django-fsm
    contrib/python/django-waffle
    contrib/python/django-picklefield
    contrib/python/celery/py2
    contrib/python/boto3
    contrib/python/pycurl
    contrib/deprecated/python/django-celery-beat
    contrib/python/django-appconf
    contrib/python/ipython
    contrib/python/attrs
    contrib/python/lxml
    contrib/python/pymorphy2
    contrib/python/dateutil
    contrib/python/py
    contrib/python/pytils
    contrib/python/regex
    contrib/python/six
    contrib/python/XlsxWriter
    contrib/python/xlwt
    contrib/python/zope.interface
    contrib/python/django-replicated

    library/python/granular_settings
    library/python/ids
    library/python/python-django-yauth
    library/python/ylog
    library/python/datasources-config-wrapper
    library/python/blackbox
    library/python/django_tools_log_context
    library/python/tvm2
    library/python/django_pgaas
    library/python/django-idm-api
    library/python/yenv
    library/python/ylock
    library/python/metrics_framework
    library/python/statface_client
    library/python/vault_client
    library/python/django-multic
    library/python/django
    library/python/errorboosterclient

    ydb/public/sdk/python
    kikimr/public/sdk/python/persqueue
    yt/python/client
    yql/library/python
    yp/python/client

    intranet/plan/django-filter
    intranet/plan/closuretree
)

PY_SRCS(
    TOP_LEVEL
    plan/metrics/idm.py
    plan/metrics/services.py
    plan/metrics/staff.py
    plan/metrics/__init__.py
    plan/metrics/other.py
    plan/metrics/apps.py
    plan/metrics/api_response.py
    plan/metrics/resources.py
    plan/metrics/duty.py
    plan/metrics/base.py
    plan/swagger.py
    plan/notify/templatetags/inclusions.py
    plan/notify/templatetags/inflections.py
    plan/notify/templatetags/__init__.py
    plan/notify/templatetags/plan_common.py
    plan/notify/migrations/__init__.py
    plan/notify/migrations/0001_initial.py
    plan/notify/core/__init__.py
    plan/notify/core/generators.py
    plan/notify/core/backends.py
    plan/notify/core/context.py
    plan/notify/core/utils.py
    plan/notify/core/email.py
    plan/notify/core/notifications.py
    plan/notify/core/transports.py
    plan/notify/models.py
    plan/notify/shortcuts.py
    plan/notify/admin/__init__.py
    plan/notify/__init__.py
    plan/notify/recipients/getters.py
    plan/notify/recipients/__init__.py
    plan/notify/recipients/objects.py
    plan/notify/apps/__init__.py
    plan/notify/apps/services/tasks.py
    plan/notify/apps/services/__init__.py
    plan/notify/apps/services/generators.py
    plan/notify/apps/services/aggregators.py
    plan/signals.py
    plan/idm/roles.py
    plan/idm/constants.py
    plan/idm/__init__.py
    plan/idm/adapters/approverequest.py
    plan/idm/adapters/rolerequest.py
    plan/idm/adapters/__init__.py
    plan/idm/adapters/role.py
    plan/idm/adapters/rolenode.py
    plan/idm/adapters/base.py
    plan/idm/exceptions.py
    plan/idm/nodes.py
    plan/idm/manager.py
    plan/ping/migrations/__init__.py
    plan/ping/migrations/0001_initial.py
    plan/ping/migrations/0002_delete_touchme.py
    plan/ping/management/__init__.py
    plan/ping/management/commands/__init__.py
    plan/ping/management/commands/ping.py
    plan/ping/__init__.py
    plan/ping/apps.py
    plan/ping/views.py
    plan/suspicion/migrations/0002_auto_20190906_1412.py
    plan/suspicion/migrations/0013_choice_correction.py
    plan/suspicion/migrations/0025_partial_constraint_appeal_issue.py
    plan/suspicion/migrations/0023_servicetype_for_issue_and_serviceissue_contex_blank_20191113_0958.py
    plan/suspicion/migrations/0027_delete_ignored_option.py
    plan/suspicion/migrations/0014_review_status_for_appeals.py
    plan/suspicion/migrations/0019_servicetrafficstatus_default_current_weight_20191014_1325.py
    plan/suspicion/migrations/__init__.py
    plan/suspicion/migrations/0016_execution_chain_linked_to_service_execution_action.py
    plan/suspicion/migrations/0020_treshold_to_thresholds.py
    plan/suspicion/migrations/0004_complaint.py
    plan/suspicion/migrations/0007_auto_20190913_1056.py
    plan/suspicion/migrations/0017_edit_for_issuegroup_20191010_1534.py
    plan/suspicion/migrations/0018_service_issue_constraint.py
    plan/suspicion/migrations/0006_auto_20190910_1242.py
    plan/suspicion/migrations/0015_fields_for_recalculation.py
    plan/suspicion/migrations/0011_rename_levels.py
    plan/suspicion/migrations/0009_appealreject.py
    plan/suspicion/migrations/0010_traffic_unique.py
    plan/suspicion/migrations/0021_serviceissue_percentage_of_completion.py
    plan/suspicion/migrations/0008_serviceappealissue.py
    plan/suspicion/migrations/0003_color_to_level.py
    plan/suspicion/migrations/0001_initial.py
    plan/suspicion/migrations/0005_charfield.py
    plan/suspicion/migrations/0024_auto_20191115_1657.py
    plan/suspicion/migrations/0012_complaint_created_at_index.py
    plan/suspicion/migrations/0022_serviceexecutionaction_date_blank.py
    plan/suspicion/migrations/0026_auto_20191209_1632.py
    plan/suspicion/execution_tasks/change_state_to_closed.py
    plan/suspicion/execution_tasks/__init__.py
    plan/suspicion/execution_tasks/change_state.py
    plan/suspicion/execution_tasks/change_state_to_need_info.py
    plan/suspicion/querysets.py
    plan/suspicion/tasks.py
    plan/suspicion/models.py
    plan/suspicion/issue_finders/crit_descendants.py
    plan/suspicion/issue_finders/gradient_vs.py
    plan/suspicion/issue_finders/cert_managers.py
    plan/suspicion/issue_finders/empty_description_en.py
    plan/suspicion/issue_finders/no_owner.py
    plan/suspicion/issue_finders/wrong_base_parent.py
    plan/suspicion/issue_finders/wrong_parent_type.py
    plan/suspicion/issue_finders/extra_functionality.py
    plan/suspicion/issue_finders/owner_is_robot.py
    plan/suspicion/issue_finders/__init__.py
    plan/suspicion/issue_finders/gradient_structure.py
    plan/suspicion/issue_finders/hardware_managers.py
    plan/suspicion/issue_finders/empty_description_ru.py
    plan/suspicion/issue_finders/base.py
    plan/suspicion/issue_finders/robot_managers.py
    plan/suspicion/tasks_helpers.py
    plan/suspicion/constants.py
    plan/suspicion/__init__.py
    plan/suspicion/apps.py
    plan/suspicion/admin.py
    plan/suspicion/api/serializers.py
    plan/suspicion/api/__init__.py
    plan/suspicion/api/filters.py
    plan/suspicion/api/views.py
    plan/suspicion/managers.py
    plan/celery_app.py
    plan/holidays/migrations/0002_holiday_is_holiday.py
    plan/holidays/migrations/__init__.py
    plan/holidays/migrations/0001_initial.py
    plan/holidays/tasks.py
    plan/holidays/models.py
    plan/holidays/management/__init__.py
    plan/holidays/management/commands/__init__.py
    plan/holidays/management/commands/sync_holidays.py
    plan/holidays/__init__.py
    plan/holidays/apps.py
    plan/holidays/calendar.py
    plan/holidays/admin.py
    plan/holidays/utils.py
    plan/holidays/api/serializers.py
    plan/holidays/api/__init__.py
    plan/holidays/api/views.py
    plan/contacts/migrations/0003_contacttype_tags.py
    plan/contacts/migrations/__init__.py
    plan/contacts/migrations/0007_auto_20180405_1324.py
    plan/contacts/migrations/0002_auto_20180118_1303.py
    plan/contacts/migrations/0005_auto_20180326_1522.py
    plan/contacts/migrations/0001_initial.py
    plan/contacts/migrations/0006_auto_20180404_1140.py
    plan/contacts/migrations/0004_auto_20180323_1907.py
    plan/contacts/models.py
    plan/contacts/controllers.py
    plan/contacts/management/__init__.py
    plan/contacts/management/commands/__init__.py
    plan/contacts/management/commands/oneoff_translate_st_query_links.py
    plan/contacts/__init__.py
    plan/contacts/apps.py
    plan/contacts/forms.py
    plan/contacts/admin.py
    plan/contacts/regexes.py
    plan/contacts/urls.py
    plan/contacts/helpers.py
    plan/contacts/views.py
    plan/resources/migrations/0036_merge.py
    plan/resources/migrations/0063_consumer_approve_policy.py
    plan/resources/migrations/0040_auto_20180406_1143.py
    plan/resources/migrations/0077_add_unique_index_20200203_1951.py
    plan/resources/migrations/0061_add_metrika_plugin_20190603_1545.py
    plan/resources/migrations/0071_auto_20191028_1618.py
    plan/resources/migrations/0009_resourcetag_service.py
    plan/resources/migrations/0055_auto_20181214_1501.py
    plan/resources/migrations/0020_auto_20180201_2348.py
    plan/resources/migrations/0030_type_supplier.py
    plan/resources/migrations/0085_auto_20201123_1303.py
    plan/resources/migrations/0086_serviceresourcecounter.py
    plan/resources/migrations/0006_resourcetype_form_mapping.py
    plan/resources/migrations/0023_resourcetag_description.py
    plan/resources/migrations/0031_resource_supplier_response.py
    plan/resources/migrations/0035_serviceresource_fsm.py
    plan/resources/migrations/0016_remove_resourcetype_form_mapping.py
    plan/resources/migrations/0048_fill_form_id.py
    plan/resources/migrations/0053_migrate_resourcetype_scopes.py
    plan/resources/migrations/0064_resource_level.py
    plan/resources/migrations/0045_add_dispenser_resource_type.py
    plan/resources/migrations/0039_auto_20180402_1749.py
    plan/resources/migrations/0054_resources_approve_policy.py
    plan/resources/migrations/0014_auto_20180116_1218.py
    plan/resources/migrations/0057_auto_20190118_1324.py
    plan/resources/migrations/0004_serviceresource_requester.py
    plan/resources/migrations/0017_rename_sourcetags_suppliertags.py
    plan/resources/migrations/__init__.py
    plan/resources/migrations/0019_auto_20180130_1524.py
    plan/resources/migrations/0041_resource_type_usage_tags.py
    plan/resources/migrations/0029_serviceresource_modified_at_index.py
    plan/resources/migrations/0075_service_tags_verbose_name.py
    plan/resources/migrations/0025_auto_20180221_1458.py
    plan/resources/migrations/0034_auto_20180315_1221.py
    plan/resources/migrations/0005_merge.py
    plan/resources/migrations/0065_add_created_at_to_resource.py
    plan/resources/migrations/0022_resourcetype_tags.py
    plan/resources/migrations/0079_serviceresource_type.py
    plan/resources/migrations/0008_resource_tags.py
    plan/resources/migrations/0080_serviceresource_type_not_null.py
    plan/resources/migrations/0059_auto_20190222_1631.py
    plan/resources/migrations/0072_service_resource_approved_at.py
    plan/resources/migrations/0051_more_serviceresource_states.py
    plan/resources/migrations/0013_resourcetype_is_enabled.py
    plan/resources/migrations/0082_typeid_answerid_unique.py
    plan/resources/migrations/0058_auto_20190218_1342.py
    plan/resources/migrations/0021_auto_20180212_1318.py
    plan/resources/migrations/0007_auto_20171117_1109.py
    plan/resources/migrations/0042_usage_tag_help_text.py
    plan/resources/migrations/0002_auto_20170606_1551.py
    plan/resources/migrations/0003_resourcetype_supplier_plugin.py
    plan/resources/migrations/0066_remove_old_constraint.py
    plan/resources/migrations/0027_resourcetype_permissions.py
    plan/resources/migrations/0074_resourcetype_service_tags.py
    plan/resources/migrations/0047_resource_type_form_id.py
    plan/resources/migrations/0081_fake_py3_migration.py
    plan/resources/migrations/0018_auto_20180125_1051.py
    plan/resources/migrations/0084_auto_20200715_1059.py
    plan/resources/migrations/0011_auto_20171221_1248.py
    plan/resources/migrations/0070_change_related_field.py
    plan/resources/migrations/0056_auto_20190110_1656.py
    plan/resources/migrations/0033_resource_name_index.py
    plan/resources/migrations/0010_resource_tag_slug_uniqueness.py
    plan/resources/migrations/0028_resourcetype_has_multiple_consumers.py
    plan/resources/migrations/0038_resource_closuretree.py
    plan/resources/migrations/0024_resourcetype_description.py
    plan/resources/migrations/0069_add_owner_roles.py
    plan/resources/migrations/0073_set_approved_at.py
    plan/resources/migrations/0003_auto_20170913_1222.py
    plan/resources/migrations/0012_resourcetype_roles.py
    plan/resources/migrations/0001_initial.py
    plan/resources/migrations/0083_yp_quota_all_rolescopes.py
    plan/resources/migrations/0046_alter_obsolete_link_tables.py
    plan/resources/migrations/0043_fix_typo.py
    plan/resources/migrations/0076_resource_add_answer_id.py
    plan/resources/migrations/0060_auto_20190316_2136.py
    plan/resources/migrations/0032_resourcetype_has_automated_grant.py
    plan/resources/migrations/0050_added_granter_and_depriver_to_serviceresource.py
    plan/resources/migrations/0034_resource_external_id.py
    plan/resources/migrations/0049_remove_form_link.py
    plan/resources/migrations/0044_resource_type_code.py
    plan/resources/migrations/0015_important_resource_types.py
    plan/resources/migrations/0078_allow_blank_service_tags.py
    plan/resources/migrations/0052_auto_20181114_1403.py
    plan/resources/migrations/0026_auto_20180226_1921.py
    plan/resources/migrations/0068_resourcetype_idempotent_request.py
    plan/resources/migrations/0037_serviceresource_state_index.py
    plan/resources/migrations/0067_add_partial_constraint.py
    plan/resources/migrations/0062_add_direct_plugin.py
    plan/resources/migrations/0087_fulltext_search_index.py
    plan/resources/migrations/0088_monitoring.py
    plan/resources/migrations/0089_alert_provider.py
    plan/suspicion/migrations/0028_issues.py
    plan/suspicion/migrations/0029_issues_fields.py
    plan/resources/exceptions.py
    plan/resources/tasks.py
    plan/resources/suppliers/fake_financial.py
    plan/resources/suppliers/billing_point.py
    plan/resources/suppliers/__init__.py
    plan/resources/suppliers/metrika.py
    plan/resources/suppliers/bot.py
    plan/resources/suppliers/tvm.py
    plan/resources/suppliers/direct.py
    plan/resources/suppliers/base.py
    plan/resources/suppliers/robots.py
    plan/resources/models.py
    plan/resources/fields.py
    plan/resources/importers/dispenser.py
    plan/resources/importers/femida.py
    plan/resources/importers/racktables.py
    plan/resources/importers/generic.py
    plan/resources/importers/__init__.py
    plan/resources/importers/qloud.py
    plan/resources/importers/crt.py
    plan/resources/importers/conductor.py
    plan/resources/importers/external_resource_data.py
    plan/resources/importers/bot.py
    plan/resources/importers/errors.py
    plan/resources/importers/wiki.py
    plan/resources/importers/nanny.py
    plan/resources/importers/base.py
    plan/resources/importers/warden.py
    plan/resources/importers/arcadia.py
    plan/resources/constants.py
    plan/resources/management/__init__.py
    plan/resources/management/commands/sync.py
    plan/resources/management/commands/abc_oneoff_fill_serviceresource_type.py
    plan/resources/management/commands/__init__.py
    plan/resources/management/commands/sync_modified_date_of_crt_resources.py
    plan/resources/management/commands/rename_resource_quota.py
    plan/resources/__init__.py
    plan/resources/apps.py
    plan/resources/forms.py
    plan/resources/gdpr_export.py
    plan/resources/admin.py
    plan/resources/permissions.py
    plan/resources/api/constructor.py
    plan/resources/api/counter.py
    plan/resources/api/validators.py
    plan/resources/api/request.py
    plan/resources/api/__init__.py
    plan/resources/api/resource_type_categories.py
    plan/resources/api/financial.py
    plan/resources/api/service_resources.py
    plan/resources/api/resource_tag_categories.py
    plan/resources/api/permissions.py
    plan/resources/api/resource_types.py
    plan/resources/api/resources.py
    plan/resources/api/base.py
    plan/resources/api/filters.py
    plan/resources/api/robots.py
    plan/resources/api/resource_tags.py
    plan/resources/router.py
    plan/resources/processing.py
    plan/resources/policies.py
    plan/resources/handlers/yp/__init__.py
    plan/resources/handlers/yp/backward.py
    plan/resources/handlers/yp/forward.py
    plan/resources/handlers/__init__.py
    plan/resources/handlers/financial_resources/direct/__init__.py
    plan/resources/handlers/financial_resources/direct/backward.py
    plan/resources/handlers/financial_resources/direct/forward.py
    plan/resources/handlers/financial_resources/__init__.py
    plan/resources/handlers/financial_resources/balance/__init__.py
    plan/resources/handlers/financial_resources/balance/forward.py
    plan/resources/handlers/gdpr/__init__.py
    plan/resources/handlers/gdpr/backward.py
    plan/resources/handlers/gdpr/forward.py
    plan/resources/handlers/billing_point/__init__.py
    plan/resources/handlers/billing_point/backward.py
    plan/resources/handlers/billing_point/forward.py
    plan/resources/handlers/staff/__init__.py
    plan/resources/handlers/staff/robot/__init__.py
    plan/resources/handlers/staff/robot/backward.py
    plan/resources/handlers/staff/robot/forward.py
    plan/resources/handlers/tvm/__init__.py
    plan/resources/handlers/tvm/forward.py
    plan/resources/handlers/tvm/backward.py
    plan/cabinet/serializers.py
    plan/cabinet/__init__.py
    plan/cabinet/apps.py
    plan/cabinet/urls.py
    plan/cabinet/helpers.py
    plan/cabinet/views.py
    plan/instances_nanny.py
    plan/hacks/migrations/__init__.py
    plan/hacks/migrations/0001_initial.py
    plan/hacks/models.py
    plan/hacks/__init__.py
    plan/hacks/apps.py
    plan/hacks/context_processors.py
    plan/hacks/admin.py
    plan/hacks/middleware.py
    plan/__init__.py
    plan/roles/migrations/0003_protected_role_scopes.py
    plan/roles/migrations/0005_auto_20181114_1403.py
    plan/roles/migrations/0004_rename_duplicate_roles.py
    plan/roles/migrations/0008_fake_py3_migration.py
    plan/roles/migrations/0009_utility_role_scopes.py
    plan/roles/migrations/__init__.py
    plan/roles/migrations/0002_auto_20170606_1551.py
    plan/roles/migrations/0001_initial.py
    plan/roles/migrations/0007_rolescope_can_issue_at_time_duty.py
    plan/roles/migrations/0006_role_exportable.py
    plan/roles/querysets.py
    plan/roles/tasks.py
    plan/roles/models.py
    plan/roles/__init__.py
    plan/roles/apps.py
    plan/roles/forms.py
    plan/roles/admin.py
    plan/roles/api/roles.py
    plan/roles/api/rolescopes.py
    plan/roles/api/validators.py
    plan/roles/api/__init__.py
    plan/roles/exceptions.py
    plan/roles/router.py
    plan/roles/urls.py
    plan/roles/views.py
    plan/departments/__init__.py
    plan/departments/urls.py
    plan/departments/views/redirect.py
    plan/departments/views/__init__.py
    plan/departments/views/department/__init__.py
    plan/departments/views/members/__init__.py
    plan/multic/__init__.py
    plan/multic/apps.py
    plan/multic/resources.py
    plan/multic/urls.py
    plan/multic/filters.py
    plan/multic/views.py
    plan/denormalization/tasks.py
    plan/denormalization/check.py
    plan/denormalization/__init__.py
    plan/denormalization/apps.py
    plan/denormalization/utils.py
    plan/denormalization/settings.py
    plan/context_processors.py
    plan/common/internal_roles.py
    plan/common/person.py
    plan/common/tasks.py
    plan/common/models.py
    plan/common/fields.py
    plan/common/base_admin.py
    plan/common/__init__.py
    plan/common/utils/hiderefer.py
    plan/common/utils/auth.py
    plan/common/utils/upd.py
    plan/common/utils/memoize.py
    plan/common/utils/collection/sorting.py
    plan/common/utils/collection/__init__.py
    plan/common/utils/collection/mapping.py
    plan/common/utils/tasks.py
    plan/common/utils/forms/mixins.py
    plan/common/utils/forms/fields.py
    plan/common/utils/forms/__init__.py
    plan/common/utils/forms/utils.py
    plan/common/utils/forms/special.py
    plan/common/utils/readonly.py
    plan/common/utils/fields.py
    plan/common/utils/query.py
    plan/common/utils/iterutils.py
    plan/common/utils/locks.py
    plan/common/utils/__init__.py
    plan/common/utils/ok.py
    plan/common/utils/watcher.py
    plan/common/utils/replicated.py
    plan/common/utils/closuretree.py
    plan/common/utils/xls.py
    plan/common/utils/context.py
    plan/common/utils/startrek.py
    plan/common/utils/restored_tree.py
    plan/common/utils/http.py
    plan/common/utils/messages.py
    plan/common/utils/tvm.py
    plan/common/utils/i18n.py
    plan/common/utils/dates.py
    plan/common/utils/sql.py
    plan/common/utils/enum.py
    plan/common/utils/timezone.py
    plan/common/utils/wrap.py
    plan/common/utils/intranet/__init__.py
    plan/common/utils/intranet/superiors.py
    plan/common/utils/intranet/departments.py
    plan/common/utils/strings.py
    plan/common/utils/oauth.py
    plan/common/utils/multic.py
    plan/common/utils/rest_fw.py
    plan/common/apps.py
    plan/common/admin.py
    plan/common/queryset.py
    plan/common/urls.py
    plan/common/middleware.py
    plan/common/views.py
    plan/puncher/__init__.py
    plan/puncher/rules.py
    plan/crutches/signals.py
    plan/crutches/__init__.py
    plan/crutches/apps.py
    plan/monitorings/__init__.py
    plan/monitorings/urls.py
    plan/monitorings/views.py
    plan/entrypoints.py
    plan/history/migrations/__init__.py
    plan/history/migrations/0001_initial.py
    plan/history/mixins.py
    plan/history/models.py
    plan/history/__init__.py
    plan/history/apps.py
    plan/history/api/serializers.py
    plan/history/api/__init__.py
    plan/history/api/filters.py
    plan/history/api/views.py
    plan/history/managers.py
    plan/abc_task.py
    plan/hr/migrations/__init__.py
    plan/hr/migrations/0004_auto_20200929_1833.py
    plan/hr/migrations/0002_auto_20170606_1551.py
    plan/hr/migrations/0001_initial.py
    plan/hr/migrations/0003_add_member_staff.py
    plan/hr/tasks.py
    plan/hr/models.py
    plan/hr/disputes.py
    plan/hr/serializer.py
    plan/hr/management/__init__.py
    plan/hr/management/commands/__init__.py
    plan/hr/management/commands/add-missing-history-records.py
    plan/hr/__init__.py
    plan/hr/apps.py
    plan/hr/forms.py
    plan/hr/admin.py
    plan/hr/urls.py
    plan/hr/helpers.py
    plan/hr/views.py
    plan/settings.py
    plan/lib/__init__.py
    plan/lib/views/mixins.py
    plan/lib/views/__init__.py
    plan/lib/views/base.py
    plan/api/auth.py
    plan/api/idm/hooks.py
    plan/api/idm/fields.py
    plan/api/idm/actions.py
    plan/api/idm/__init__.py
    plan/api/idm/forms.py
    plan/api/idm/helpers.py
    plan/api/idm/external_subsystem_hooks.py
    plan/api/dispenser/actions.py
    plan/api/mixins.py
    plan/api/fields.py
    plan/api/validators.py
    plan/api/serializers.py
    plan/api/suggests/mixins.py
    plan/api/suggests/__init__.py
    plan/api/suggests/roles/serializers.py
    plan/api/suggests/roles/__init__.py
    plan/api/suggests/roles/views.py
    plan/api/suggests/persons/serializers.py
    plan/api/suggests/persons/__init__.py
    plan/api/suggests/persons/views.py
    plan/api/suggests/pagination.py
    plan/api/suggests/urls.py
    plan/api/suggests/services/__init__.py
    plan/api/suggests/services/views.py
    plan/api/method_fields/__init__.py
    plan/api/__init__.py
    plan/api/apps.py
    plan/api/exceptions/handler.py
    plan/api/exceptions/__init__.py
    plan/api/forms.py
    plan/api/permissions.py
    plan/api/router.py
    plan/api/urls.py
    plan/api/base.py
    plan/api/intranet/persons.py
    plan/api/intranet/__init__.py
    plan/api/filters.py
    plan/api/views.py
    plan/assessors/__init__.py
    plan/assessors/api/__init__.py
    plan/assessors/api/views.py
    plan/exceptions.py
    plan/maintenance/tasks.py
    plan/maintenance/management/__init__.py
    plan/maintenance/management/commands/__init__.py
    plan/maintenance/management/commands/regenerate_closure_tree.py
    plan/maintenance/__init__.py
    plan/maintenance/apps.py
    plan/maintenance/admin.py
    plan/maintenance/middleware.py
    plan/internal_roles/migrations/0007_extend_permissions_for_internal_roles_20200204_1434.py
    plan/internal_roles/migrations/0006_add_financial_creator.py
    plan/internal_roles/migrations/0010_auto_20200520_0330.py
    plan/internal_roles/migrations/0008_change_meta_options.py
    plan/internal_roles/migrations/0009_change_meta_options.py
    plan/internal_roles/migrations/0004_auto_20180511_1115.py
    plan/internal_roles/migrations/__init__.py
    plan/internal_roles/migrations/0003_remove_old_perms.py
    plan/internal_roles/migrations/0001_initial.py
    plan/internal_roles/migrations/0005_auto_20190208_1629.py
    plan/internal_roles/migrations/0002_roles_as_perms.py
    plan/internal_roles/models.py
    plan/internal_roles/management/commands/migrate-roles.py
    plan/internal_roles/__init__.py
    plan/internal_roles/apps.py
    plan/internal_roles/admin.py
    plan/internal_roles/utils.py
    plan/staff/migrations/0008_staff_add_chief_20200929_1833.py
    plan/staff/migrations/0009_is_frozen.py
    plan/staff/migrations/0010_telegram.py
    plan/staff/migrations/__init__.py
    plan/staff/migrations/0006_set_not_null_staff_staff_id.py
    plan/staff/migrations/0003_add_service_scope.py
    plan/staff/migrations/0004_drop_not_null.py
    plan/staff/migrations/0007_auto_20200520_0330.py
    plan/staff/migrations/0005_staff_staff_id.py
    plan/staff/migrations/0001_initial.py
    plan/staff/migrations/0002_add_closure_tree.py
    plan/staff/querysets.py
    plan/staff/tasks.py
    plan/staff/models.py
    plan/staff/constants.py
    plan/staff/__init__.py
    plan/staff/apps.py
    plan/staff/admin.py
    plan/staff/utils.py
    plan/staff/api/serializers.py
    plan/staff/api/__init__.py
    plan/staff/api/views.py
    plan/staff/base.py
    plan/staff/views.py
    plan/unistat/migrations/0005_taskmetric_migrate_old_data.py
    plan/unistat/migrations/0007_taskmetric_use_for_monitoring.py
    plan/unistat/migrations/0004_taskmetric_add_fields.py
    plan/unistat/migrations/0002_auto_20181205_1358.py
    plan/unistat/migrations/__init__.py
    plan/unistat/migrations/0006_taskmetric_drop_old_field.py
    plan/unistat/migrations/0003_taskmetric.py
    plan/unistat/migrations/0001_initial.py
    plan/unistat/tasks.py
    plan/unistat/models.py
    plan/unistat/__init__.py
    plan/unistat/apps.py
    plan/unistat/admin.py
    plan/unistat/views.py
    plan/idm_ext/__init__.py
    plan/idm_ext/urls.py
    plan/idm_ext/views.py
    plan/urls.py
    plan/duty/migrations/0004_shift_replace_for.py
    plan/duty/migrations/0051_auto_20200720_1520.py
    plan/duty/migrations/0036_auto_20191106_1817.py
    plan/duty/migrations/0062_auto_20201202_1840.py
    plan/duty/migrations/0037_add_schedule_start_time.py
    plan/duty/migrations/0047_gap_statuses_default_created_at.py
    plan/duty/migrations/0045_schedule_days_for_begin_shift_notification.py
    plan/duty/migrations/0052_cleanup_inactive_schedules.py
    plan/duty/migrations/0061_schedule_recalculate.py
    plan/duty/migrations/0010_gap.py
    plan/duty/migrations/0021_moving_fields_from_calendar_to_schedule.py
    plan/duty/migrations/0022_copy_values_from_calendar_to_schedule.py
    plan/duty/migrations/0050_schedule_autoapprove_timedelta.py
    plan/duty/migrations/0049_remove_schedule_autoapprove.py
    plan/duty/migrations/0008_shift_date_of_last_notification.py
    plan/duty/migrations/0006_auto_20190218_1049.py
    plan/duty/migrations/0024_schedule_change_unique_together.py
    plan/duty/migrations/0012_auto_20190313_1341.py
    plan/duty/migrations/0063_schedule_add_holidays_and_weekends_20201211_1849.py
    plan/duty/migrations/0064_auto_20210601_2327.py
    plan/duty/migrations/0032_problem.py
    plan/duty/migrations/0044_schedule_days_for_problem_notification.py
    plan/duty/migrations/0048_gap_created_add_auto_now_add.py
    plan/duty/migrations/0007_auto_20190220_1147.py
    plan/duty/migrations/0058_set_deleted_at.py
    plan/duty/migrations/0057_schedule_deleted_at.py
    plan/duty/migrations/0042_shift_datetime_fields_drop_null.py
    plan/duty/migrations/0002_shift_is_approved.py
    plan/duty/migrations/__init__.py
    plan/duty/migrations/0046_schedule_show_in_staff.py
    plan/duty/migrations/0020_schedule_calendar_nullable.py
    plan/duty/migrations/0005_auto_20190215_1048.py
    plan/duty/migrations/0003_auto_20190117_1456.py
    plan/duty/migrations/0019_add_duty_order_table.py
    plan/duty/migrations/0028_removing_notification_dates_from_shift.py
    plan/duty/migrations/0035_add_indexes.py
    plan/duty/migrations/0013_auto_20190326_1215.py
    plan/duty/migrations/0060_schedule_description.py
    plan/duty/migrations/0054_populate_shift_role.py
    plan/duty/migrations/0033_delete_calendar_20190723_2127.py
    plan/duty/migrations/0038_schedule_allow_repeat_one_human.py
    plan/duty/migrations/0059_auto_20201006_1304.py
    plan/duty/migrations/0026_order_staff_not_null.py
    plan/duty/migrations/0027_schedule_role_on_duty.py
    plan/duty/migrations/0025_manual_ordering_changes.py
    plan/duty/migrations/0055_problem_datetime.py
    plan/duty/migrations/0039_change_schedule_default_start_time.py
    plan/duty/migrations/0014_shift_has_problems.py
    plan/duty/migrations/0009_schedule_unique_together_20190307_1419.py
    plan/duty/migrations/0011_calendar_autoapprove.py
    plan/duty/migrations/0017_shift_date_of_last_bad_notification.py
    plan/duty/migrations/0015_schedule_persons_count.py
    plan/duty/migrations/0040_auto_20200228_1624.py
    plan/duty/migrations/0001_initial.py
    plan/duty/migrations/0029_schedule_slug.py
    plan/duty/migrations/0031_uniq_schedule_slug.py
    plan/duty/migrations/0030_edit_shift_20190710_1249.py
    plan/duty/migrations/0053_remove_member_add_role.py
    plan/duty/migrations/0023_nonnull_schedule_fields.py
    plan/duty/migrations/0041_shift_add_datetime_fields.py
    plan/duty/migrations/0018_schedule_consider_other_schedules.py
    plan/duty/migrations/0056_auto_20200803_1321.py
    plan/duty/migrations/0034_order_staff_is_null_20190813_0142.py
    plan/duty/migrations/0016_shift_add_member_remove_role_20190403_1403.py
    plan/duty/migrations/0043_created_for_shifts.py
    plan/duty/migrations/0065_auto_20210713_2327.py
    plan/duty/migrations/0066_is_important.py
    plan/duty/migrations/0067_duty_to_watcher.py
    plan/duty/tasks.py
    plan/duty/tracker.py
    plan/duty/models.py
    plan/duty/constants.py
    plan/duty/management/__init__.py
    plan/duty/management/commands/__init__.py
    plan/duty/management/commands/get_duty_consumers.py
    plan/duty/management/commands/abc_oneoff_fill_shift_datetime_fields.py
    plan/duty/__init__.py
    plan/duty/apps.py
    plan/duty/admin.py
    plan/duty/utils.py
    plan/duty/permissions.py
    plan/duty/api/metadata.py
    plan/duty/api/validators.py
    plan/duty/api/serializers.py
    plan/duty/api/__init__.py
    plan/duty/api/permissions.py
    plan/duty/api/filters.py
    plan/duty/api/views.py
    plan/duty/exceptions.py
    plan/duty/schedulers/ordered_staff.py
    plan/duty/schedulers/__init__.py
    plan/duty/schedulers/auto_ordering_scheduler.py
    plan/duty/schedulers/scheduler.py
    plan/duty/schedulers/manual_ordering_scheduler.py
    plan/services/migrations/0091_servicenotification_new_notification_ids.py
    plan/services/migrations/0026_servicetag_slug.py
    plan/services/migrations/0054_add__has_external_members.py
    plan/services/migrations/0034_remove_team_states.py
    plan/services/migrations/0016_auto_20180205_1603.py
    plan/services/migrations/0035_add_denormalized_fields.py
    plan/services/migrations/0070_add_suspicious_date_suspicious_notification_date_1600.py
    plan/services/migrations/0094_fake_py3_migration.py
    plan/services/migrations/0063_auto_20190117_1456.py
    plan/services/migrations/0029_servicestat.py
    plan/services/migrations/0097_auto_20200518_2221.py
    plan/services/migrations/0088_servicemoverequest_from_creation.py
    plan/services/migrations/0068_auto_20190211_1920.py
    plan/services/migrations/0107_auto_20210111_2248.py
    plan/services/migrations/0108_auto_20210402_1257.py
    plan/services/migrations/0109_add_servicemoverequest_start_moving_idm.py
    plan/services/migrations/0110_service_member_add_autorequested.py
    plan/services/migrations/0111_service_member_set_autorequested.py
    plan/services/migrations/0112_service_add_use_for_hardware.py
    plan/services/migrations/0113_service_member_add_idm_role_id.py
    plan/services/migrations/0114_service_members_count.py
    plan/services/migrations/0115_auto_20210812_1257.py
    plan/services/migrations/0116_servicetag_add_protected.py
    plan/services/migrations/0117_create_servicetag_permissions.py
    plan/services/migrations/0118_service_add_use_for_group_only.py
    plan/services/migrations/0119_service_add_flags.py
    plan/services/migrations/0120_oebs_parent_id.py
    plan/services/migrations/0121_oebs_data.py
    plan/services/migrations/0122_service_functions.py
    plan/services/migrations/0123_service_types.py
    plan/services/migrations/0069_service_vacancies_count.py
    plan/services/migrations/0059_add_service_type.py
    plan/services/migrations/0104_auto_20200929_1833.py
    plan/services/migrations/0018_auto_20180301_2151.py
    plan/services/migrations/0045_remove_servicemoverequest_is_deleted.py
    plan/services/migrations/0023_auto_20180315_1429.py
    plan/services/migrations/0027_service_move_request_fsm.py
    plan/services/migrations/0005_auto_20170813_1006.py
    plan/services/migrations/0040_remove_service_is_vteam.py
    plan/services/migrations/0096_servicenotification_days_before_shift.py
    plan/services/migrations/0051_clean_member_duplicates.py
    plan/services/migrations/0036_auto_20180511_1115.py
    plan/services/migrations/0087_service_readonly_start_time.py
    plan/services/migrations/0061_add_related_services.py
    plan/services/migrations/0101_auto_20200813_1700.py
    plan/services/migrations/0098_enlarge_content_of_contacts.py
    plan/services/migrations/0100_servicenotification_real_days_before_shift.py
    plan/services/migrations/0015_auto_20180205_0948.py
    plan/services/migrations/0046_serviceresponsible_migrated.py
    plan/services/migrations/0081_remove_mptt_fields_from_service.py
    plan/services/migrations/0065_auto_20190122_1818.py
    plan/services/migrations/0066_add_service_membership_inheritance_20190122_1854.py
    plan/services/migrations/0004_service_readonly_state.py
    plan/services/migrations/__init__.py
    plan/services/migrations/0042_service_department.py
    plan/services/migrations/0037_default_service_state.py
    plan/services/migrations/0032_remove_servicemember_is_senior.py
    plan/services/migrations/0014_auto_20180118_1345.py
    plan/services/migrations/0031_auto_20180411_1535.py
    plan/services/migrations/0056_django_1_10.py
    plan/services/migrations/0060_auto_20181206_1238.py
    plan/services/migrations/0030_readonly_state_choices.py
    plan/services/migrations/0021_auto_20180312_0855.py
    plan/services/migrations/0002_clean_contacts.py
    plan/services/migrations/0072_auto_20190326_1215.py
    plan/services/migrations/0047_service_slug_citext.py
    plan/services/migrations/0079_service_is_base.py
    plan/services/migrations/0028_auto_20180409_1500.py
    plan/services/migrations/0074_servicenotification.py
    plan/services/migrations/0052_service_members_unique.py
    plan/services/migrations/0075_servicesuspiciousreason_rename_emptyservice_20190626_1545.py
    plan/services/migrations/0071_service_remove_is_suspicious.py
    plan/services/migrations/0011_readonly_state.py
    plan/services/migrations/0019_auto_20180302_1004.py
    plan/services/migrations/0048_delete_serviceresponsible.py
    plan/services/migrations/0033_purge_deleted_memberships.py
    plan/services/migrations/0073_service_sandbox_move_date.py
    plan/services/migrations/0055_service_unique_immediate_robots_count.py
    plan/services/migrations/0089_add_trafficstatus_in_servicenotification_20191213_1707.py
    plan/services/migrations/0043_service_create_request.py
    plan/services/migrations/0106_auto_20201221_1750.py
    plan/services/migrations/0049_service_rules_counters.py
    plan/services/migrations/0025_auto_20180326_1548.py
    plan/services/migrations/0080_add_closuretree_fields_to_service.py
    plan/services/migrations/0044_service_delete_request.py
    plan/services/migrations/0103_servicenotification_add_spliced_shifts_count_20200918_1404.py
    plan/services/migrations/0082_base_service_susp_reason.py
    plan/services/migrations/0058_remove_service_department.py
    plan/services/migrations/0007_auto_20170914_2132.py
    plan/services/migrations/0090_servicenotification_complaints_count.py
    plan/services/migrations/0067_auto_20190208_1629.py
    plan/services/migrations/0008_auto_20171018_1652.py
    plan/services/migrations/0013_auto_20180118_1344.py
    plan/services/migrations/0022_service_exportable.py
    plan/services/migrations/0085_add_interactive_at.py
    plan/services/migrations/0003_delete_deprecated_fields.py
    plan/services/migrations/0105_auto_20201123_1303.py
    plan/services/migrations/0102_create_request_add_approver_20200902_1200.py
    plan/services/migrations/0076_add_shift_field_to_notification.py
    plan/services/migrations/0092_auto_20191224_1759.py
    plan/services/migrations/0053_service_suspicious_reason.py
    plan/services/migrations/0039_remove_servicecontact_deleted.py
    plan/services/migrations/0077_add_lastshift_servicenotification_20190710_1249.py
    plan/services/migrations/0001_initial.py
    plan/services/migrations/0012_vteam_tag.py
    plan/services/migrations/0062_auto_20190110_1656.py
    plan/services/migrations/0020_auto_20180312_0854.py
    plan/services/migrations/0006_auto_20170816_1423.py
    plan/services/migrations/0024_remove_services_perms.py
    plan/services/migrations/0064_auto_20190118_1324.py
    plan/services/migrations/0009_auto_20171218_1325.py
    plan/services/migrations/0084_servicenotification_email.py
    plan/services/migrations/0057_service_departments.py
    plan/services/migrations/0095_service_staff_id.py
    plan/services/migrations/0010_servicetag.py
    plan/services/migrations/0017_services_verbose_names.py
    plan/services/migrations/0083_servicemember_found_in_staff_at.py
    plan/services/migrations/0099_remove_servicenotification_shift_begin_today_flag.py
    plan/services/migrations/0050_alter_create_request_states.py
    plan/services/migrations/0093_delete_ignored_option.py
    plan/services/migrations/0041_move_request_optional_fields.py
    plan/services/migrations/0038_auto_20180523_1121.py
    plan/services/migrations/0086_auto_20191105_1722.py
    plan/services/migrations/0078_servicenotification_problem.py
    plan/services/migrations/0124_service_unique_external_members_count.py
    plan/services/migrations/0125_contact_title_en.py
    plan/services/tasks.py
    plan/services/models.py
    plan/services/checkers.py
    plan/services/constants/__init__.py
    plan/services/constants/action.py
    plan/services/constants/api_frontend.py
    plan/services/constants/permissions.py
    plan/services/management/__init__.py
    plan/services/management/commands/autoapprove_move_requests_with_sandbox.py
    plan/services/management/commands/add-links-to-services.py
    plan/services/management/commands/__init__.py
    plan/services/management/commands/check-nodes.py
    plan/services/management/commands/export-services.py
    plan/services/management/commands/fix-owners.py
    plan/services/management/commands/deep_disable_membership_inheritance.py
    plan/mdh/tasks.py
    plan/mdh/management/__init__.py
    plan/mdh/management/commands/mdh_reexport.py
    plan/mdh/management/commands/__init__.py
    plan/mdh/__init__.py
    plan/mdh/apps.py
    plan/mdh/utils.py
    plan/periodic/__init__.py
    plan/periodic/apps.py
    plan/periodic/models.py
    plan/periodic/utils.py
    plan/periodic/migrations/__init__.py
    plan/periodic/migrations/0001_initial.py
    plan/services/__init__.py
    plan/services/utils/__init__.py
    plan/services/utils/xls.py
    plan/services/types.py
    plan/services/apps.py
    plan/services/operations/__init__.py
    plan/services/operations/validate.py
    plan/services/operations/process.py
    plan/services/operations/prepare.py
    plan/services/forms.py
    plan/services/admin.py
    plan/services/denormalization.py
    plan/services/permissions.py
    plan/services/functionality.py
    plan/services/api/exceptions.py
    plan/services/api/tags.py
    plan/services/api/services.py
    plan/services/api/moves.py
    plan/services/api/contacts.py
    plan/services/api/creates.py
    plan/services/api/members.py
    plan/services/api/gradient.py
    plan/services/api/validators.py
    plan/services/api/responsibles.py
    plan/services/api/parent.py
    plan/services/api/frontend.py
    plan/services/api/__init__.py
    plan/services/api/team.py
    plan/services/api/permissions.py
    plan/services/api/team_statuses.py
    plan/services/api/slug.py
    plan/services/api/departments.py
    plan/services/exceptions.py
    plan/services/router.py
    plan/services/urls.py
    plan/services/views/create.py
    plan/services/views/catalog/builders.py
    plan/services/views/catalog/__init__.py
    plan/services/views/catalog/forms.py
    plan/services/views/catalog/views.py
    plan/services/views/catalog/serializers.py
    plan/services/views/__init__.py
    plan/services/views/detail.py
    plan/services/helpers.py
    plan/services/state.py
    plan/services/signals.py
    plan/oebs/migrations/0002_oebsagreement_requester.py
    plan/oebs/migrations/__init__.py
    plan/oebs/migrations/0005_oebsagreement_notify_only.py
    plan/oebs/migrations/0003_oebsagreement_ok_id.py
    plan/oebs/migrations/0001_initial.py
    plan/oebs/migrations/0004_auto_20210128_1308.py
    plan/oebs/tasks/check_process.py
    plan/oebs/tasks/start_approve.py
    plan/oebs/tasks/finish_approve.py
    plan/oebs/models.py
    plan/oebs/constants.py
    plan/oebs/__init__.py
    plan/oebs/apps.py
    plan/oebs/admin.py
    plan/oebs/utils.py
    plan/oebs/api/serializers.py
    plan/oebs/api/permissions.py
    plan/oebs/api/__init__.py
    plan/oebs/api/views.py
    plan/oebs/exceptions.py
    plan/test_settings.py
    plan/wsgi.py
)

RESOURCE_FILES(
    PREFIX intranet/plan/src/

    plan/settings/077-sentry.conf
    plan/settings/045-url-whitelist.conf
    plan/settings/200-resources.conf
    plan/settings/000-config.conf.development
    plan/settings/310-notifications.conf
    plan/settings/030-apps.conf
    plan/settings/065-email.conf
    plan/settings/300-abc.conf
    plan/settings/085-permissions.conf
    plan/settings/082-logging.conf.development
    plan/settings/320-gradient.conf
    plan/settings/180-denormalization.conf
    plan/settings/150-django.conf
    plan/settings/400-intrasearch.conf
    plan/settings/305-metrics.conf
    plan/settings/004-urls.conf
    plan/settings/000-config.conf
    plan/settings/020-database.conf.development
    plan/settings/040-middleware.conf
    plan/settings/080-logging.conf
    plan/settings/900-yp.conf.development
    plan/settings/051-intranet.conf
    plan/settings/610-swagger.conf
    plan/settings/150-django.conf.development
    plan/settings/160-ylock.conf
    plan/settings/910-ok.conf
    plan/settings/900-yp.conf
    plan/settings/015-static.conf
    plan/settings/003-urls.conf
    plan/settings/400-intrasearch.conf.production
    plan/settings/800-monitorings.conf
    plan/settings/040-middleware.conf.production
    plan/settings/410-oebs.conf
    plan/settings/410-oebs.conf.testing
    plan/settings/410-oebs.conf.production
    plan/settings/005-warnings.conf
    plan/settings/078-sentry.conf
    plan/settings/100-auth.conf
    plan/settings/302-suspicious.conf
    plan/settings/100-auth.conf.production
    plan/settings/050-intranet.conf.production
    plan/settings/003-urls.conf.development
    plan/settings/300-abc.conf.production
    plan/settings/330-mdh.conf
    plan/settings/330-mdh.conf.production
    plan/settings/190-idm.conf
    plan/settings/001-site.conf
    plan/settings/075-session.conf
    plan/settings/120-celery.conf
    plan/settings/077-sentry.conf.production
    plan/settings/910-ok.conf.testing
    plan/settings/020-database.conf
    plan/settings/006-time.conf
    plan/settings/190-idm.conf.production
    plan/settings/600-rest.conf
    plan/settings/330-forms.conf
    plan/settings/301-duty.conf
    plan/settings/003-urls.conf.testing
    plan/settings/190-idm.conf.development
    plan/settings/011-path.conf
    plan/settings/050-intranet.conf
    plan/settings/060-templates.conf
    plan/settings/070-cache.conf
    plan/settings/500-init.conf
    plan/settings/200-resources.conf.testing
    plan/settings/066-email.conf.development
    plan/settings/190-idm.conf.testing
    plan/settings/700-api_nanny.conf
    plan/settings/200-resources.conf.production
    plan/settings/077-sentry.conf.testing
    plan/settings/090-i18n.conf
    plan/settings/006-time.conf.development

    plan/notify/templates/notifications/mixed/unspecified_dates_reminder_ru.html
    plan/notify/templates/notifications/base_email.html
    plan/notify/templates/notifications/hr/person_participation_dispute_review_ru.html
    plan/notify/templates/notifications/hr/person_participation_dispute_raise_ru.html
    plan/notify/templates/notifications/maintenance/remind_meta_other_heads_ru.html
    plan/notify/templates/notifications/maintenance/check_nodes_ru.html
    plan/notify/templates/notifications/duty/shift_has_problems_ru.html
    plan/notify/templates/notifications/duty/shift_start_or_soon_ru.html
    plan/notify/templates/notifications/services/you_were_added_ru.html
    plan/notify/templates/notifications/services/approve_team_reminder_ru.html
    plan/notify/templates/notifications/services/approve_department_ru.html
    plan/notify/templates/notifications/services/service_was_moved_ru.html
    plan/notify/templates/notifications/services/approve_members_ru.html
    plan/notify/templates/notifications/services/chown_request_ru.html
    plan/notify/templates/notifications/services/management/check_roles_ru.html
    plan/notify/templates/notifications/services/management/sync_owners_ru.html
    plan/notify/templates/notifications/services/management/sync_responsible_ru.html
    plan/notify/templates/notifications/services/approve_department_removal_ru.html
    plan/notify/templates/notifications/services/suspicious/base_suspicious.html
    plan/notify/templates/notifications/services/suspicious/has_modified_ru.html
    plan/notify/templates/notifications/services/suspicious/decision_on_appeal_ru.html
    plan/notify/templates/notifications/services/suspicious/move_suspicious_service_one_day_ru.html
    plan/notify/templates/notifications/services/suspicious/suspicion_digest_ru.html
    plan/notify/templates/notifications/services/suspicious/new_appeal_created_ru.html
    plan/notify/templates/notifications/services/team_changed_ru.html
    plan/notify/templates/notifications/services/you_were_removed_ru.html
    plan/notify/templates/notifications/services/your_services_ru.html
    plan/notify/templates/notifications/services/move_request_incoming_ru.html
    plan/notify/templates/notifications/services/move_request_outgoing_ru.html

    plan/locale/ru/LC_MESSAGES/django.mo
    plan/locale/ru/LC_MESSAGES/django.po
    plan/locale/en/LC_MESSAGES/django.mo
    plan/locale/en/LC_MESSAGES/django.po

    plan/resources/templates/yp_quota_ticket.txt

    plan/templates/include/person_link.html
    plan/templates/maintenance.html

    plan/oebs/templates/oebs_approve_ticket.txt
    plan/oebs/templates/oebs_agreement_error_issue.txt
    plan/oebs/templates/oebs_support_error_ticket.txt

    plan/swagger/swagger_description.md
)

NO_CHECK_IMPORTS(
    closuretree.*
    django_autoconfig.*
    django_pgaas.*
    rest_framework.*
    django_extensions.*
    multic.*
    django.*
    plan.services.views.catalog.forms
    errorboosterclient.*
)

END()
