PY3TEST()

OWNER(g:tools-abc)

ENV(PYTEST_ADDOPTS=--tb=short --no-migrations --disable-warnings)
ENV(DJANGO_SETTINGS_MODULE=plan.test_settings)
ENV(ABC_DEBUG=1)
ENV(ABC_DATABASE_SSL=0)
ENV(YENV_TYPE=development.unittest)
ENV(YENV_NAME=intranet)
ENV(PYTHONHASHSEED=0)

INCLUDE(${ARCADIA_ROOT}/antiadblock/postgres_local/recipe/recipe.inc)
DEPENDS(
  antiadblock/postgres_local/recipe
)

SIZE(MEDIUM)

NO_DOCTESTS()

PEERDIR(
    intranet/plan/src

    contrib/python/pytest-django
    contrib/python/vcrpy
    contrib/python/mock
    contrib/python/ipdb
    contrib/python/factory-boy
    contrib/python/freezegun
    contrib/python/pretend
    contrib/python/pytest-xdist
    contrib/python/xlrd
    contrib/python/openpyxl

    library/python/django
)

DATA(
    arcadia/intranet/plan/tests/test_data/
)

TEST_SRCS(
    unit/metrics/test_idm.py
    unit/metrics/__init__.py
    unit/metrics/test_staff.py
    unit/metrics/test_duty.py
    unit/notify/core/test_utils.py
    unit/notify/core/test_transports.py
    unit/notify/core/__init__.py
    unit/notify/core/test_notifications.py
    unit/notify/__init__.py
    unit/notify/recipients/test_getters.py
    unit/notify/recipients/__init__.py
    unit/notify/recipients/test_objects.py
    unit/notify/apps/__init__.py
    unit/notify/apps/services/test_team.py
    unit/notify/apps/services/__init__.py
    unit/idm/conftest.py
    unit/idm/test_actions.py
    unit/idm/test_nodes.py
    unit/idm/__init__.py
    unit/idm/test_roles.py
    unit/idm/test_manager.py
    unit/ping/__init__.py
    unit/ping/test_ping.py
    unit/suspicion/conftest.py
    unit/suspicion/__init__.py
    unit/suspicion/models/test_traffic_status.py
    unit/suspicion/models/test_service_execution_action.py
    unit/suspicion/models/test_service_issue.py
    unit/suspicion/models/__init__.py
    unit/suspicion/test_notifications.py
    unit/suspicion/test_tasks.py
    unit/suspicion/test_issue_finders.py
    unit/suspicion/api/test_complaints.py
    unit/suspicion/api/__init__.py
    unit/suspicion/api/test_appeals.py
    unit/suspicion/api/test_thresholds.py
    unit/suspicion/api/test_issues.py
    unit/suspicion/test_executions.py
    unit/holidays/__init__.py
    unit/holidays/test_tasks.py
    unit/holidays/api/__init__.py
    unit/holidays/api/test_holidays.py
    unit/holidays/test_holiday.py
    unit/holidays/test_calendar_workdays.py
    unit/contacts/__init__.py
    unit/contacts/test_regexes.py
    unit/contacts/test_commands.py
    unit/contacts/test_contacttypes.py
    unit/contacts/test_normalize.py
    unit/resources/test_resources.py
    unit/resources/conftest.py
    unit/resources/supplier_plugins/test_direct.py
    unit/resources/supplier_plugins/__init__.py
    unit/resources/supplier_plugins/test_bot.py
    unit/resources/supplier_plugins/test_billing_point.py
    unit/resources/supplier_plugins/test_tvm.py
    unit/resources/test_tag_categories.py
    unit/resources/test_type_categories.py
    unit/resources/test_financial_resource_request.py
    unit/resources/test_bot_sync.py
    unit/resources/importers/test_conductor.py
    unit/resources/importers/test_crt.py
    unit/resources/importers/test_nanny.py
    unit/resources/importers/__init__.py
    unit/resources/importers/test_generic.py
    unit/resources/importers/test_racktables.py
    unit/resources/importers/test_oebs.py
    unit/resources/importers/test_femida.py
    unit/resources/importers/test_dispenser.py
    unit/resources/importers/test_qloud.py
    unit/resources/importers/test_warden.py
    unit/resources/importers/test_arcadia.py
    unit/resources/test_request.py
    unit/resources/__init__.py
    unit/resources/test_resource_types.py
    unit/resources/test_robots.py
    unit/resources/test_constructor.py
    unit/resources/test_counter.py
    unit/resources/test_gdpr_export.py
    unit/resources/test_tasks.py
    unit/resources/test_resources_permissions.py
    unit/resources/test_oebs_product.py
    unit/resources/test_dispenser_sync.py
    unit/resources/test_resource_tags.py
    unit/resources/test_service_tags.py
    unit/resources/test_quota_donation.py
    unit/resources/test_permissions.py
    unit/resources/test_service_resources.py
    unit/cabinet/conftest.py
    unit/cabinet/__init__.py
    unit/cabinet/test_count.py
    unit/cabinet/test_moves.py
    unit/cabinet/test_roles.py
    unit/hacks/test_werewolf.py
    unit/hacks/__init__.py
    unit/__init__.py
    unit/roles/test_views.py
    unit/roles/api/__init__.py
    unit/roles/api/test_roles.py
    unit/utils/collection/test_mapping/test_sequence_keys.py
    unit/utils/collection/test_mapping/test_mapping_iterables.py
    unit/utils/collection/test_mapping/test_update_dict.py
    unit/utils/collection/test_mapping/__init__.py
    unit/utils/collection/test_mapping/test_multiple_keys.py
    unit/utils/collection/test_mapping/test_data_accessed_dict.py
    unit/utils/collection/test_mapping/test_revert_mapping_of_iterables.py
    unit/utils/collection/test_mapping/test_subdict.py
    unit/utils/collection/test_mapping/test_group_by_as_dict.py
    unit/utils/collection/__init__.py
    unit/utils/__init__.py
    unit/utils/test_upd/__init__.py
    unit/utils/test_upd/test_process.py
    unit/utils/test_upd/test_validate.py
    unit/utils/test_upd/test_prepare.py
    unit/utils/test_tasks.py
    unit/utils/test_strings.py
    unit/utils/intranet/__init__.py
    unit/utils/intranet/test_startrek.py
    unit/multic/__init__.py
    unit/multic/test_multic.py
    unit/common/test_ok.py
    unit/common/__init__.py
    unit/common/test_person.py
    unit/monitorings/test_granting_resource.py
    unit/monitorings/__init__.py
    unit/monitorings/test_missing_resources_robots.py
    unit/monitorings/test_failed_tasks.py
    unit/history/conftest.py
    unit/history/__init__.py
    unit/history/test_update.py
    unit/history/test_create.py
    unit/history/test_api.py
    unit/hr/__init__.py
    unit/hr/test_views.py
    unit/api/suggest/test_persons.py
    unit/api/suggest/test_services.py
    unit/api/suggest/__init__.py
    unit/api/suggest/test_roles.py
    unit/api/test_cors.py
    unit/api/idm/test_actions.py
    unit/api/idm/__init__.py
    unit/api/idm/test_hooks.py
    unit/api/test_common.py
    unit/api/test_frontend_permissions.py
    unit/api/__init__.py
    unit/api/test_denying_middleware.py
    unit/api/test_waffle.py
    unit/api/test_fields.py
    unit/api/test_language.py
    unit/api/intranet/__init__.py
    unit/api/intranet/test_person.py
    unit/api/test_tvm.py
    unit/maintenance/__init__.py
    unit/maintenance/test_tasks.py
    unit/staff/test_sync.py
    unit/staff/__init__.py
    unit/staff/test_api.py
    unit/staff/test_inflection.py
    unit/test_unistat.py
    unit/conftest.py
    unit/duty/conftest.py
    unit/duty/test_staff_orderer.py
    unit/duty/__init__.py
    unit/duty/test_scheduler.py
    unit/duty/test_tasks.py
    unit/duty/api/conftest.py
    unit/duty/api/test_on_duty.py
    unit/duty/api/test_shift.py
    unit/duty/api/__init__.py
    unit/duty/api/test_allow_for_duty.py
    unit/duty/api/test_schedule_manual_order.py
    unit/duty/api/test_schedule.py
    unit/duty/api/test_upload_history.py
    unit/duty/api/test_gaps.py
    unit/services/test_base_services.py
    unit/services/test_suspicious.py
    unit/services/conftest.py
    unit/services/test_services.py
    unit/services/__init__.py
    unit/services/test_checkers.py
    unit/services/operations/__init__.py
    unit/services/operations/test_process.py
    unit/services/operations/test_validate.py
    unit/services/operations/test_prepare.py
    unit/services/test_commands.py
    unit/services/test_tasks.py
    unit/services/api/test_gradient.py
    unit/services/api/test_creates.py
    unit/services/api/test_servicetags.py
    unit/services/api/conftest.py
    unit/services/api/test_members.py
    unit/services/api/test_denormalization.py
    unit/services/api/test_requested_roles.py
    unit/services/api/test_team.py
    unit/services/api/test_services.py
    unit/services/api/test_api_frontend.py
    unit/services/api/__init__.py
    unit/services/api/test_contacts.py
    unit/services/api/test_departments.py
    unit/services/api/test_moves.py
    unit/services/api/test_new_roles.py
    unit/services/api/test_parent.py
    unit/services/api/test_responsibles.py
    unit/services/api/test_services_export.py
    unit/services/api/test_slug.py
    unit/services/api/test_team_statuses.py
    unit/services/test_helpers.py
    unit/services/test_functionality.py
    unit/services/test_bot.py
    unit/services/views/test_detail.py
    unit/services/views/test_catalog.py
    unit/services/views/test_actions.py
    unit/services/views/__init__.py
    unit/services/views/test_contacts.py
    unit/services/views/test_create.py
    unit/services/handlers/test_member_departments.py
    unit/services/handlers/__init__.py
    unit/oebs/test_utils.py
    unit/oebs/conftest.py
    unit/oebs/__init__.py
    unit/oebs/test_tasks.py
    unit/oebs/api/__init__.py
    unit/oebs/api/test_views.py
    conftest.py
    test_data/resources/yp/__init__.py
    test_data/resources/yp/form_metadata.py
    test_data/resources/__init__.py
    test_data/__init__.py
    __init__.py
    common/intranet.py
    common/__init__.py
    common/templates.py
    common/factories/internal_roles.py
    common/factories/services.py
    common/factories/staff.py
    common/factories/contacts.py
    common/factories/roles.py
    common/factories/waffles.py
    common/factories/__init__.py
    common/factories/hr.py
    common/factories/oebs.py
    common/factories/suspicion.py
    common/factories/resources.py
    common/factories/duty.py
    common/factories/holidays.py
    common/factories/history.py
    common/factories/unistat.py
    common/fixtures/models.py
    common/fixtures/__init__.py
    common/fixtures/mocks.py
    common/decorators.py
    integrational/idm_sdk/test_service.py
    integrational/idm_sdk/__init__.py
    integrational/__init__.py
    unit/mdh/__init__.py
    unit/mdh/test_mdh.py
    unit/periodic/__init__.py
    unit/periodic/test_periodic.py
    unit/services/api/test_tags.py
)

PY_SRCS(
    utils.py
)

IF (NOT NO_FORK_TESTS)
    FORK_SUBTESTS()
    SPLIT_FACTOR(35)
ENDIF()

END()
