# coding: utf-8

import logging
import re
from hashlib import md5
from xml.dom import minidom
from xml.etree.ElementTree import Element, tostring

from faker import Factory
from flask import Flask, Response, request

logger = logging.getLogger(__name__)

# ------------------------------------------------------------------------------

DBFIELDS = {
    'mkznts': {
        'accounts.login.uid': 'mkznts',
        'userinfo.firstname.uid': 'Максим',
        'userinfo.lastname.uid': 'Кузнецов',
        'userinfo.lang.uid': 'en',
        'userinfo.sex.uid': '1',
    },
    'robot-procu': {
        'accounts.login.uid': 'robot-procu',
        'userinfo.firstname.uid': 'Робот',
        'userinfo.lastname.uid': 'Закупок',
        'userinfo.lang.uid': 'ru',
        'userinfo.sex.uid': '1',
    },
}

# ------------------------------------------------------------------------------

app = Flask(__name__)


def prettify(elem):
    """
    Return a pretty-printed XML string for the Element.
    """
    rough_string = tostring(elem, 'utf-8')
    reparsed = minidom.parseString(rough_string)
    return reparsed.toprettyxml(indent='  ', encoding='UTF-8')


def __(elem, **kwargs):
    for key, value in kwargs.items():
        setattr(elem, key, value)
    return elem


@app.route('/')
def blackbox():

    top = Element('doc')

    method = request.args.get('method', '')
    session_id = request.args.get('sessionid', '')

    try:
        login = re.search(r'\|login:(.+?)\|', session_id).group(1)
    except AttributeError:
        login = 'robot-procu'

    if login == 'fail':
        raise ValueError('Expected Error')

    uid = '' if login == 'notfound' else '1130000000038044'

    if method == 'sessionid':

        top.extend(
            [
                __(Element('status', attrib={'id': '0'}), text='VALID'),
                __(Element('error'), text='OK'),
                __(Element('login'), text=login),
                __(Element('uid'), text=uid),
                __(
                    Element(
                        'new-session',
                        attrib={
                            'domain': '.yandex-team.ru',
                            'expires': '0',
                            'http-only': '1',
                        },
                    ),
                    text='38472cd49fb888ef2a8cf078bb0d2553'
                    '73f008c9f7f38f0380e1957567c0bb0d',
                ),
                __(
                    Element(
                        'new-sslsession',
                        attrib={
                            'domain': '.yandex-team.ru',
                            'expires': '0',
                            'http-only': '1',
                        },
                    ),
                    text='5a04f3955d169534dab67cd9deebf06c'
                    '44ac97c27b8d921c17f5426eba0ea48c',
                ),
            ]
        )

    if method == 'userinfo':
        top.extend(
            [
                __(Element('uid', attrib={'hosted': '0'}), text=uid),
                __(Element('login'), text=login),
                __(Element('have_password'), text='1'),
            ]
        )

    if login != 'notfound':
        try:
            fields = DBFIELDS[login]

        except KeyError:
            fake = Factory.create('ru_RU')
            fake.seed(int(md5(login.encode()).hexdigest(), 16))

            fields = {
                'accounts.login.uid': login,
                'userinfo.firstname.uid': fake.first_name_female(),
                'userinfo.lastname.uid': fake.last_name_female(),
                'userinfo.lang.uid': 'ru',
                'userinfo.sex.uid': '2',
            }

        for field, value in fields.items():
            top.append(__(Element('dbfield', attrib={'id': field}), text=value))

        address_list = Element('address-list')
        address_list.append(
            __(
                Element(
                    'address',
                    attrib={'validated': '1', 'default': '1', 'native': '1'},
                ),
                text=login + '@yandex-team.ru',
            )
        )

        top.append(address_list)

    return Response(prettify(top), mimetype='text/xml')


if __name__ == '__main__':
    app.run(port=80, debug=False, host='0.0.0.0')
