# coding: utf-8

import datasources_config_wrapper
import yenv
import re

from json import loads

ds = datasources_config_wrapper.DatasourcesConfigWrapper(
    prefix='procu',
    suppress_warning=True,
    local_datasources_path='/etc/yandex/tools-datasources/datasources-local.py',
    fallback_on_env_vars=True,
)

IS_DEVELOPMENT = yenv.type == 'development'
IS_TESTING = yenv.type == 'testing'
IS_PRODUCTION = yenv.type == 'production'

# Development
if IS_DEVELOPMENT:
    ORACLE_TNS = """
    (DESCRIPTION_LIST=
        (FAILOVER=on)
        (DESCRIPTION=
            (FAILOVER=on)
            (LOAD_BALANCE=on)
            (ADDRESS_LIST=
                (ADDRESS=
                    (PROTOCOL=TCP)
                    (HOST=ps-node02h-vip.yandex.ru)
                    (PORT=1521)
                )
            )
            (CONNECT_DATA=
                (FAILOVER_MODE=
                    (TYPE=select)
                    (METHOD=basic)
                    (RETRIES=3)
                    (DELAY=5)
                )
                (SERVER=dedicated)
                (SERVICE_NAME=metadevdb)
            )
        )
    )
    """

elif IS_TESTING:
    ORACLE_TNS = """
    (DESCRIPTION_LIST =
        (FAILOVER = on)
        (DESCRIPTION =
            (FAILOVER = on)
            (LOAD_BALANCE = on)
            (ADDRESS_LIST =
                (ADDRESS =
                    (PROTOCOL = TCP)
                    (HOST = ps-node03h-vip.yandex.ru)
                    (PORT = 1521)
                )
                (ADDRESS =
                    (PROTOCOL = TCP)
                    (HOST = ps-node04h-vip.yandex.ru)
                    (PORT = 1521)
                )
            )
            (CONNECT_DATA =
                (FAILOVER_MODE =
                    (TYPE = select)
                    (METHOD = basic)
                    (RETRIES = 3)
                    (DELAY = 5)
                )
                (SERVER = dedicated)
                (SERVICE_NAME = metatstdb)
            )
        )
    )
    """

elif IS_PRODUCTION:
    ORACLE_TNS = """
    (DESCRIPTION_LIST=
     (FAILOVER=on)
     (DESCRIPTION=
     (ENABLE=BROKEN)
     (LOAD_BALANCE=on)
     (FAILOVER=on)
     (address = (protocol = tcp)(host = meta1e-vip.yandex.ru)(port = 1521))
     (address = (protocol = tcp)(host = meta2e-vip.yandex.ru)(port = 1521))
     (
       connect_data =
      (service_name=metadb)
      (server=dedicated)
      (
        failover_mode=
          (type=select)
          (method=basic)
          (retries=3)
          (delay=5)
      )
      )
     )
     (DESCRIPTION=
     (ENABLE=BROKEN)
     (LOAD_BALANCE=on)
     (FAILOVER=on)
     (address = (protocol = tcp)(host = meta1f-vip.yandex.ru)(port = 1521))
     (address = (protocol = tcp)(host = meta2f-vip.yandex.ru)(port = 1521))
     (
       connect_data =
      (service_name=metadb)
      (server=dedicated)
      (
        failover_mode=
          (type=select)
          (method=basic)
          (retries=3)
          (delay=5)
       )
      )
     )
     (DESCRIPTION=
     (ENABLE=BROKEN)
     (LOAD_BALANCE=on)
     (FAILOVER=on)
     (address = (protocol = tcp)(host = meta1v-vip.paysys.yandex.net)(port = 1521))
     (address = (protocol = tcp)(host = meta2v-vip.paysys.yandex.net)(port = 1521))
     (
       connect_data =
      (service_name=metadb)
      (server=dedicated)
      (
        failover_mode=
          (type=select)
          (method=basic)
          (retries=3)
          (delay=5)
       )
      )
     )
    )
    """

else:
    ORACLE_TNS = ''

ORACLE_TNS = re.sub(r'\s', '', ORACLE_TNS)

ORACLE_USER = ds.oebs_user
ORACLE_PASS = ds.oebs_password

PG_DBNAME = ds.db_name
PG_HOST = ','.join(h['name'] for h in loads(ds.db_hosts)['hosts'])
PG_USER = ds.db_user
PG_PASS = ds.db_password
PG_PORT = ds.db_port
