# coding: utf-8

from procu.rest import generics
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import ExternalOnly, NonColdOnly, WithSupplierOnly
from . import serializers


class SupplierView(generics.RetrieveUpdateAPIView):
    pagination_class = PageNumberPagination
    permission_classes = (ExternalOnly, NonColdOnly, WithSupplierOnly)

    def get_serializer_class(self):
        if self.request.method == 'PATCH':
            return serializers.Update

        return serializers.Retrieve

    def get_object(self):
        return self.request.user.supplier
