# coding: utf-8

from rest_framework.filters import OrderingFilter

from procu.api import models
from procu.rest import generics, mixins
from procu.rest.filters import SearchFilter
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import EntryPermission, ListPermission
from . import serializers


class AddressList(generics.ListCreateAPIView):
    pagination_class = PageNumberPagination
    queryset = models.Address.objects.filter(is_deleted=False)
    output_serializer_class = serializers.CreateRetrieveUpdate
    permission_classes = (ListPermission,)
    filter_backends = (SearchFilter, OrderingFilter)
    search_fields = ('label', 'comment', 'text')
    ordering = ('label',)

    def get_serializer_class(self):
        cl = {'GET': serializers.List, 'POST': serializers.CreateRetrieveUpdate}
        return cl[self.request.method]


class AddressEntry(
    mixins.MakeDeletedImmutable, generics.RetrieveUpdateDestroyAPIView
):

    queryset = models.Address.objects.all()
    serializer_class = serializers.CreateRetrieveUpdate
    permission_classes = (EntryPermission,)
    lookup_url_kwarg = 'address_id'
