# coding: utf-8

from django.utils.translation import gettext_lazy as _

from procu.api import models
from procu.api.common.fields import EmployeeField
from procu.rest import serializers


class EnquiryCategoryBriefSerializer(serializers.ModelSerializer):
    sourcing_time = serializers.DurationField(read_only=True)
    completion_time = serializers.DurationField(read_only=True)

    class Meta:
        model = models.EnquiryCategory
        fields = ('id', 'name', 'sourcing_time', 'completion_time')


class ListRetrieve(serializers.ModelSerializer):
    sourcing_time = serializers.DurationField(required=False)
    completion_time = serializers.DurationField(required=False)

    managers = EmployeeField(required=False, allow_empty=True, many=True)

    class Meta:
        model = models.EnquiryCategory
        fields = (
            'id',
            'name',
            'sourcing_time',
            'completion_time',
            'managers',
            'is_deleted',
        )
        extra_kwargs = {
            'is_deleted': {'label': _('ENQUIRY_CATEGORY::IS_DELETED')}
        }


class CreateUpdateAdmin(serializers.ModelSerializer):
    sourcing_time = serializers.DurationField(required=False)
    completion_time = serializers.DurationField(required=False)

    managers = EmployeeField(required=False, allow_empty=True, many=True)

    class Meta:
        model = models.EnquiryCategory
        fields = (
            'id',
            'name',
            'sourcing_time',
            'completion_time',
            'managers',
            'is_deleted',
        )
        extra_kwargs = {
            'is_deleted': {'label': _('ENQUIRY_CATEGORY::IS_DELETED')}
        }


class CreateUpdateNonAdmin(serializers.ModelSerializer):
    sourcing_time = serializers.DurationField(required=False)
    completion_time = serializers.DurationField(required=False)

    class Meta:
        model = models.EnquiryCategory
        fields = (
            'id',
            'name',
            'sourcing_time',
            'completion_time',
            'is_deleted',
        )
        extra_kwargs = {
            'is_deleted': {'label': _('ENQUIRY_CATEGORY::IS_DELETED')}
        }
