# coding: utf-8

from procu.api import models
from procu.rest import generics, mixins
from procu.rest.filters import SearchFilter
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import EntryPermission, ListPermission
from . import serializers


class EnquiryCategoryList(generics.ListCreateAPIView):
    pagination_class = PageNumberPagination
    queryset = models.EnquiryCategory.objects.prefetch_related(
        'managers'
    ).filter(is_deleted=False)
    serializer_class = serializers.ListRetrieve
    permission_classes = (ListPermission,)
    filter_backends = (SearchFilter,)
    search_fields = ('name',)

    def get_serializer_class(self):

        if self.request.method == 'GET':
            return serializers.ListRetrieve

        elif self.request.user.has_perm('api.all_enquiry'):
            return serializers.CreateUpdateAdmin

        else:
            return serializers.CreateUpdateNonAdmin


class EnquiryCategoryEntry(
    mixins.MakeDeletedImmutable, generics.RetrieveUpdateDestroyAPIView
):

    queryset = models.EnquiryCategory.objects.prefetch_related('managers')
    permission_classes = (EntryPermission,)
    lookup_url_kwarg = 'category_id'

    def get_serializer_class(self):

        if self.request.method == 'GET':
            return serializers.ListRetrieve

        elif self.request.user.has_perm('api.all_enquiry'):
            return serializers.CreateUpdateAdmin

        else:
            return serializers.CreateUpdateNonAdmin
