# coding: utf-8

from procu.api import models
from procu.rest import generics
from procu.rest.filters import SearchFilter
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import EntryPermission, ListPermission
from . import serializers


class ContactListCreate(generics.ListCreateAPIView):
    permission_classes = (ListPermission,)
    pagination_class = PageNumberPagination
    filter_backends = (SearchFilter,)
    output_serializer_class = serializers.Retrieve

    search_fields = (
        'first_name',
        'last_name',
        'email',
        'supplier__title',
        'supplier__legal_name',
    )
    queryset = models.User.objects.filter(
        is_staff=False, is_deleted=False
    ).select_related('supplier')

    def get_serializer_class(self):
        if self.request.method == 'POST':
            return serializers.Create
        else:
            return serializers.List


class ContactRetrieveUpdateDestroy(generics.RetrieveUpdateDestroyAPIView):
    permission_classes = (EntryPermission,)
    queryset = models.User.objects.filter(is_staff=False).select_related(
        'supplier'
    )
    output_serializer_class = serializers.Retrieve
    lookup_url_kwarg = 'user_id'

    def get_serializer_class(self):
        if self.request.method == 'PATCH':
            return serializers.Update
        else:
            return serializers.Retrieve
