# coding: utf-8

from django.utils.translation import gettext_lazy as _

from procu.api import models
from procu.rest import serializers
from procu.rest.fields import MonetaryField


class OracleCurrency(serializers.ModelSerializer):
    class Meta:
        model = models.OracleCurrency
        fields = ('id', 'key', 'name')


class CurrencySerializer(serializers.ModelSerializer):
    nominal = serializers.IntegerField(min_value=0)
    rate = MonetaryField(decimal_places=4, allow_null=False)
    oracle_currency = serializers.PKPrettyField(
        serializer=OracleCurrency,
        queryset=models.OracleCurrency.objects.all(),
        allow_null=True,
    )

    class Meta:
        model = models.Currency
        fields = '__all__'
        extra_kwargs = {
            'char_code': {'allow_blank': False, 'required': True},
            'is_deleted': {'label': _('CURRENCY::IS_DELETED')},
        }


class CurrencyBriefSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.Currency
        fields = ('id', 'prefix', 'suffix')
