# coding: utf-8

from procu.api import models
from procu.rest import filters, generics, mixins
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import EntryPermission
from .permissions import CurrencyListPermission
from .serializers import CurrencySerializer


class CurrencyList(generics.ListCreateAPIView):
    queryset = models.Currency.objects.prefetch_related(
        'oracle_currency'
    ).filter(is_deleted=False)
    serializer_class = CurrencySerializer
    pagination_class = PageNumberPagination
    permission_classes = (CurrencyListPermission,)
    filter_backends = (filters.SearchFilter,)
    search_fields = ('code', 'char_code', 'prefix', 'suffix', 'name')


class CurrencyEntry(
    mixins.MakeDeletedImmutable, generics.RetrieveUpdateDestroyAPIView
):
    queryset = models.Currency.objects.prefetch_related('oracle_currency').all()
    serializer_class = CurrencySerializer
    permission_classes = (EntryPermission,)
    lookup_url_kwarg = 'currency_id'
