# coding: utf-8

from procu.api import models
from procu.rest import serializers


class Create(serializers.ModelSerializer):
    class Meta:
        model = models.Dashboard
        fields = ('id', 'name', 'is_public')
        extra_kwargs = {'name': {'max_length': 255}}


class Widget(serializers.ModelSerializer):
    class Meta:
        model = models.DashboardWidget
        fields = ('id',)


class Retrieve(serializers.ModelSerializer):

    widgets = Widget(many=True)

    class Meta:
        model = models.Dashboard
        fields = ('id', 'name', 'is_public', 'widgets')


class Update(serializers.ModelSerializer):
    class Meta:
        model = models.Dashboard
        fields = ('id', 'name', 'is_public')
        extra_kwargs = {'name': {'max_length': 255}}
