# coding: utf-8

from django.conf.urls import include, url

from .views import *


def _include(path):
    return include('procu.api.dashboard.%s' % path)


urlpatterns = [
    url(
        r'^/(?P<dashboard_id>[0-9]+)',
        include(
            [
                url(r'^/widgets', _include('widget.urls')),
                url(r'/?$', DashboardRetrieveUpdateDestroy.as_view()),
            ]
        ),
    ),
    url(r'^/?$', DashboardCreate.as_view()),
]
