# coding: utf-8

from procu.api import models
from procu.rest import generics
from procu.rest.permissions import StaffOnly
from . import serializers


class WidgetCreate(generics.CreateAPIView):
    permission_classes = (StaffOnly,)
    serializer_class = serializers.Widget

    queryset = models.Dashboard.objects.filter(is_deleted=False)

    def perform_create(self, serializer):
        return serializer.save(dashboard_id=self.kwargs['dashboard_id'])


class WidgetRetrieveUpdateDestroy(generics.RetrieveUpdateDestroyAPIView):
    permission_classes = (StaffOnly,)

    lookup_url_kwarg = 'widget_id'

    def get_queryset(self):
        return models.DashboardWidget.objects.filter(
            is_deleted=False, dashboard_id=self.kwargs['dashboard_id']
        )

    def get_serializer_class(self):

        if self.request.method == 'GET':
            return serializers.Widget
        else:
            return serializers.Widget
