# coding: utf-8

from django.utils.translation import gettext_lazy as _
from psycopg2.extras import DateRange
from rest_framework.exceptions import ValidationError

from procu.api import models
from procu.rest import serializers


class DateRangeField(serializers.ListField):
    def __init__(self, *args, **kwargs):
        kwargs['child'] = serializers.DateField()
        kwargs['min_length'] = 2
        kwargs['max_length'] = 2
        super().__init__(*args, **kwargs)

    def to_representation(self, value):
        return [value.lower, value.upper]


class DiscountSerializer(serializers.ModelSerializer):
    dates = DateRangeField()

    class Meta:
        model = models.Discount
        fields = ('id', 'value', 'dates')

    def validate_dates(self, value):

        if value[0] >= value[1]:
            raise ValidationError(_('DATE_RANGE_FIELD::EMPTY'))

        rng = DateRange(value[0], value[1])

        qs = models.Discount.objects.all()

        if self.instance is not None:
            qs = qs.exclude(pk=self.instance.pk)

        if qs.filter(dates__overlap=rng).exists():
            raise ValidationError(_('DISCOUNT::RANGE_OVERLAP'))

        return rng
