# coding: utf-8

from rest_framework.filters import OrderingFilter

from procu.api import models
from procu.rest import generics
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import EntryPermission, ListPermission
from .serializers import DiscountSerializer


class DiscountList(generics.ListCreateAPIView):
    queryset = models.Discount.objects
    serializer_class = DiscountSerializer
    pagination_class = PageNumberPagination
    permission_classes = (ListPermission,)
    filter_backends = (OrderingFilter,)
    ordering_fields = ('id', 'value', 'dates')
    ordering = ('-dates', 'id')


class DiscountEntry(generics.RetrieveUpdateDestroyAPIView):
    queryset = models.Discount.objects.all()
    serializer_class = DiscountSerializer
    permission_classes = (EntryPermission,)
    lookup_url_kwarg = 'discount_id'
