# coding: utf-8

from rest_framework.permissions import BasePermission, SAFE_METHODS

from procu.api import models


class AccessPermissions(BasePermission):
    def has_permission(self, request, view):

        qs = models.Enquiry.objects.permitted(request.user).filter(
            id=view.kwargs['enquiry_id']
        )

        if not qs.exists():
            return False

        if request.method not in SAFE_METHODS:
            return request.user.has_perm('api.progress_enquiry')

        return True
