# coding: utf-8
from procu.api import models
from procu.api.enums import ACCESS_SOURCE
from .serializers import is_author_or_assignee


def give_access_to_user(enquiry_id, user):

    obj, created = models.EnquiryAccess.objects.update_or_create(
        user=user, enquiry_id=enquiry_id
    )

    is_already_in = ACCESS_SOURCE.ACCESS in obj.sources

    if not is_already_in:
        perm = user.has_perm('api.progress_enquiry')
        obj.allow_quote_comments = perm

        obj.is_subscribed = is_author_or_assignee(obj)

    obj.sources = list({*obj.sources} | {ACCESS_SOURCE.ACCESS})
    obj.save(update_fields=['sources', 'allow_quote_comments', 'is_subscribed'])

    return obj
