# coding: utf-8

from procu.api import models
from procu.rest.permissions import EntryPermission, ListPermission


class ListCreate(ListPermission):
    def has_permission(self, request, view):
        if not super().has_permission(request, view):
            return False

        if request.method == 'POST':
            return (
                models.Enquiry.objects.permitted(request.user)
                .filter(id=view.kwargs['enquiry_id'])
                .exists()
            )

        return True


class UpdateDelete(EntryPermission):
    def has_object_permission(self, request, view, obj):
        if request.method in ('PATCH', 'DELETE'):
            return obj.author_id == request.user.id
        return True
