# coding: utf-8
from django.utils.translation import gettext_lazy as _

from procu import jsonschema as js
from procu.rest import serializers


class EnumPK(serializers.PKPrettyField):
    def __init__(self, display_field, custom=False, *args, **kwargs):
        self.display_field = display_field
        self.custom = custom
        super().__init__(*args, **kwargs)

    def to_internal_value(self, data):
        if self.custom and data == '__custom__':
            return None
        return super().to_internal_value(data)

    def to_representation(self, value):
        if self.custom and value == '__custom__':
            return {'id': '__custom__'}
        return super().to_representation(value)

    def get_schema(self, write=False, *args, **kwargs):
        if write:
            values = list(self.queryset.values_list('id', flat=True))

            if self.custom:
                values.append('__custom__')

            display_names = dict(
                self.queryset.values_list('id', self.display_field)
            )

            if self.custom:
                display_names['__custom__'] = _('ENUM_FIELD::CUSTOM_VALUE')

            return js.String(enum=values, **{'x-names': display_names})

        else:
            return super().get_schema(write, *args, **kwargs)
