# coding: utf-8

from django.conf import settings

from procu.api import models
from procu.rest.permissions import EntryPermission


class CheckoutPermission(EntryPermission):
    model_class = models.Enquiry

    if settings.IS_PRODUCTION:
        default_perms_map = {'POST': ['dummy'], 'GET': ['dummy']}
    else:
        default_perms_map = {
            'POST': ['%(app_label)s.checkout_%(model_name)s'],
            'GET': ['%(app_label)s.checkout_%(model_name)s'],
        }
