# coding: utf-8

from django.urls import include, path, re_path

from .views import *


def _include(_path):
    return include('procu.api.enquiry.invoice.%s' % _path)


urlpatterns = [
    re_path(r'^/?$', Invoice.as_view()),
    path(
        '/<int:invoice_id>',
        include(
            [
                path('/products', _include('products.urls')),
                re_path(r'^/?$', InvoiceRetrieveUpdateDestroy.as_view()),
            ]
        ),
    ),
]
