# coding: utf-8

import re

from django.utils.translation import gettext_lazy as _

from procu.api.common.fields import EnumField
from procu.api.enums import LINK
from procu.rest import serializers

TICKET_REGEX = re.compile(r'^/?(\w+)-(\d+)$', flags=re.I)


class LinkCreatedItem(serializers.Serializer):
    id = serializers.CharField(allow_blank=False)
    type = EnumField(enum_class=LINK)


class LinkCreate(serializers.Serializer):
    links = LinkCreatedItem(many=True, style={'x-hint': _('LINK::ENTER_KEY')})

    def validate(self, data):
        valid_links = []

        for link in data['links']:
            if link['id'].isdigit() or TICKET_REGEX.match(link['id']):
                valid_links.append(link)

        data['links'] = valid_links

        return data
